# Complete Optimization Problem and Solution: inn_1

## 1. Problem Context and Goals

### Context  
The business operates a hotel and seeks to optimize room allocation decisions to maximize revenue while adhering to operational constraints. The primary decision involves determining whether to accept or reject each reservation request. Each reservation has an associated rate, which represents the revenue generated if the reservation is accepted. The hotel has a fixed maximum occupancy per room, ensuring that the number of guests does not exceed the room's capacity. Additionally, the system must prevent double-booking by ensuring that no two reservations for the same room overlap in their check-in and check-out dates.  

The business configuration includes a maximum occupancy limit of 4 guests per room, which serves as a constraint on the total number of guests that can be accommodated. The system also employs a formula to detect overlapping reservation dates, ensuring that only one reservation is accepted for any given room during the same time period. These constraints are designed to maintain operational feasibility while maximizing revenue.  

The optimization problem is formulated linearly, focusing on straightforward relationships between decision variables, revenue, and constraints. This ensures that the problem remains computationally tractable and aligned with business needs.  

### Goals  
The primary goal of this optimization problem is to maximize the total revenue generated from accepted reservations. This is achieved by strategically deciding which reservations to accept, based on their associated rates, while ensuring that room capacities are not exceeded and that no double-booking occurs. Success is measured by the total revenue generated, which is directly tied to the rates of the accepted reservations. The optimization process aims to make decisions that align with these objectives, ensuring that the hotel operates efficiently and profitably.  

## 2. Constraints  

The optimization problem is subject to the following constraints:  

1. **Room Capacity Constraint**: The total number of guests across all accepted reservations for a room must not exceed the maximum occupancy limit of 4 guests. This ensures that the room is not overbooked and that guest comfort and safety are maintained.  

2. **Date Overlap Constraint**: For any two reservations that overlap in their check-in and check-out dates, only one of them can be accepted. This prevents double-booking and ensures that each room is allocated to only one reservation at any given time.  

These constraints are designed to reflect real-world operational limitations and are expressed in a way that naturally leads to a linear optimization formulation.  

## 3. Available Data  

### Database Schema  
```sql
-- Iteration 1 Database Schema
-- Objective: Schema changes include adding a new table for decision variables and updating configuration logic to handle date overlap constraints. Business configuration logic now includes scalar parameters and formulas for optimization.

CREATE TABLE ReservationDecisions (
  AcceptReservation BOOLEAN
);

CREATE TABLE Reservations (
  Rate FLOAT,
  AcceptReservation BOOLEAN
);
```

### Data Dictionary  
- **ReservationDecisions Table**:  
  - **Purpose**: Stores the decision to accept or reject each reservation.  
  - **AcceptReservation Column**:  
    - **Business Meaning**: Indicates whether a reservation is accepted (1) or rejected (0).  
    - **Optimization Role**: Serves as the binary decision variable in the optimization model.  

- **Reservations Table**:  
  - **Purpose**: Stores details of each reservation, including the revenue it generates.  
  - **Rate Column**:  
    - **Business Meaning**: The revenue generated from each reservation.  
    - **Optimization Role**: Used as the coefficient in the objective function to maximize total revenue.  
  - **AcceptReservation Column**:  
    - **Business Meaning**: Indicates whether a reservation is accepted (1) or rejected (0).  
    - **Optimization Role**: Serves as the binary decision variable in the optimization model.  


### Retrieved Values

**Query 1: Purpose: This query provides the essential data needed for the objective function (maximizing revenue) and the decision variables (whether to accept or reject each reservation).**

```sql
SELECT Rate, AcceptReservation FROM Reservations;
```

**Results (CSV format):**
```csv
Rate,AcceptReservation
120.0,1
100.0,0
150.0,1
110.0,1
130.0,0
```

**Query 2: Purpose: This query helps in understanding the current state of accepted reservations, which is crucial for ensuring that the room capacity constraint is not violated.**

```sql
SELECT COUNT(*) AS TotalAcceptedReservations FROM Reservations WHERE AcceptReservation = TRUE;
```

**Results (CSV format):**
```csv
TotalAcceptedReservations
3
```

**Query 3: Purpose: This query helps in calculating the total revenue, which is the objective function to be maximized.**

```sql
SELECT SUM(Rate) AS TotalRevenue FROM Reservations WHERE AcceptReservation = TRUE;
```

**Results (CSV format):**
```csv
TotalRevenue
380.0
```

**Query 4: Purpose: This query provides the total capacity of all rooms, which is a key constraint in the optimization problem.**

```sql
SELECT SUM(Capacity) AS TotalCapacity FROM Rooms;
```

**Error:** Execution failed on sql 'SELECT SUM(Capacity) AS TotalCapacity FROM Rooms;': no such table: Rooms

**Query 5: Purpose: This query helps in ensuring that the number of accepted reservations does not exceed the total room capacity.**

```sql
SELECT SUM(Capacity) AS TotalRoomCapacity FROM Rooms;
```

**Error:** Execution failed on sql 'SELECT SUM(Capacity) AS TotalRoomCapacity FROM Rooms;': no such table: Rooms

**Query 6: Purpose: This query helps in ensuring that the total weather impact constraint is not violated.**

```sql
SELECT total_weather_impact FROM route_constraints;
```

**Error:** Execution failed on sql 'SELECT total_weather_impact FROM route_constraints;': no such table: route_constraints

**Query 7: Purpose: This query helps in ensuring that the total weather impact does not exceed the allowed limit.**

```sql
SELECT total_impact FROM total_weather_impact;
```

**Error:** Execution failed on sql 'SELECT total_impact FROM total_weather_impact;': no such table: total_weather_impact

**Query 8: Purpose: This query helps in ensuring that the total weather impact does not exceed the allowed limit.**

```sql
SELECT SUM(route_length) AS total_route_length FROM route_planning WHERE route_variable = TRUE;
```

**Error:** Execution failed on sql 'SELECT SUM(route_length) AS total_route_length FROM route_planning WHERE route_variable = TRUE;': no such table: route_planning

**Query 9: Purpose: This query helps in ensuring that the total weather impact does not exceed the allowed limit.**

```sql
SELECT SUM(route_length) AS total_weather_impact FROM route_planning WHERE route_variable = TRUE;
```

**Error:** Execution failed on sql 'SELECT SUM(route_length) AS total_weather_impact FROM route_planning WHERE route_variable = TRUE;': no such table: route_planning

**Query 10: Purpose: This query helps in ensuring that the number of selected routes does not exceed the total capacity.**

```sql
SELECT COUNT(*) AS total_selected_routes FROM route_planning WHERE route_variable = TRUE;
```

**Error:** Execution failed on sql 'SELECT COUNT(*) AS total_selected_routes FROM route_planning WHERE route_variable = TRUE;': no such table: route_planning

**Query 11: Purpose: This query helps in ensuring that the total weather impact of all selected routes does not exceed the allowed limit.**

```sql
SELECT SUM(route_length) AS total_weather_impact FROM route_planning WHERE route_variable = TRUE;
```

**Error:** Execution failed on sql 'SELECT SUM(route_length) AS total_weather_impact FROM route_planning WHERE route_variable = TRUE;': no such table: route_planning

