# Complete Optimization Problem and Solution: journal_committee

## 1. Problem Context and Goals

### Context  
A publishing company is focused on maximizing the total sales of its journals by strategically assigning editors to journals. The company ensures that each journal is assigned at least one editor and that no editor is overburdened with too many journals. The decision to assign an editor to a journal is represented by a binary variable, where a value of true indicates an assignment and false indicates no assignment. The company uses the sales figures of each journal as a key metric to drive the optimization process. Additionally, the company has set a maximum workload limit for each editor, ensuring that no editor is assigned more journals than they can handle. The assignment process also considers the expertise of editors, ensuring that editors are matched to journals based on their thematic alignment. This expertise matching is calculated by comparing the editor's expertise theme with the journal's theme, resulting in a binary match indicator. The optimization problem is designed to be linear, avoiding any nonlinear relationships such as variable products or divisions.

### Goals  
The primary goal of this optimization problem is to maximize the total sales of journals by making optimal assignments of editors to journals. Success is measured by the sum of sales from all journals, where each journal's sales figure is multiplied by the assignment decision. The company aims to achieve this goal while respecting the constraints on editor workloads and ensuring that each journal is assigned at least one editor. The optimization process is designed to be linear, focusing on straightforward, additive relationships that align with the company's operational parameters.

## 2. Constraints    

The optimization problem is subject to two key constraints. First, the total number of journals assigned to each editor must not exceed the editor's maximum workload limit. This ensures that no editor is overburdened and can effectively manage their assigned journals. Second, each journal must be assigned at least one editor. This ensures that every journal has the necessary editorial oversight and support. Both constraints are designed to be linear, avoiding any complex relationships or nonlinear interactions.

## 3. Available Data  

### Database Schema  
```sql
-- Iteration 1 Database Schema
-- Objective: Schema changes include creating new tables for editor expertise and workload limits, modifying the journal_committee table to better represent assignments, and adding configuration logic for scalar parameters and formulas.

CREATE TABLE journal (
  Sales FLOAT
);

CREATE TABLE editor_expertise (
  theme STRING
);

CREATE TABLE editor_workload (
  Max_Workload INTEGER
);

CREATE TABLE journal_committee (
  Assign_ej BOOLEAN
);
```

### Data Dictionary  
- **journal**: Stores details about each journal, including its sales figures. The sales figures are used as coefficients in the objective function to maximize total sales.
  - **Sales**: Represents the sales of the journal, used as a coefficient in the objective function.

- **editor_expertise**: Stores information about the expertise of each editor, specifically the themes they are knowledgeable in. This information is used to match editors to journals based on thematic alignment.
  - **theme**: Represents the theme of expertise for an editor, used in the expertise matching formula.

- **editor_workload**: Stores the maximum number of journals each editor can handle. This information is used to set the constraint bounds for editor workloads.
  - **Max_Workload**: Represents the maximum number of journals an editor can handle, used as a constraint bound.

- **journal_committee**: Stores the assignments of editors to journals. The assignment decisions are represented as binary variables in the optimization model.
  - **Assign_ej**: Represents the assignment of an editor to a journal, used as a decision variable in the optimization model.


### Retrieved Values

**Query 1: Query Description: Retrieve the sales figures for all journals. This data is crucial as it serves as the coefficient in the objective function to maximize total sales.**

```sql
SELECT Sales FROM journal;
```

**Results (CSV format):**
```csv
Sales
1200.0
1800.0
900.0
```

**Query 2: Query Description: Retrieve the maximum workload limits for all editors. This data is essential for setting the constraint bounds to ensure no editor is overburdened.**

```sql
SELECT Max_Workload FROM editor_workload;
```

**Results (CSV format):**
```csv
Max_Workload
4
3
5
```

**Query 3: Query Description: Retrieve the expertise themes of all editors. This data is important for matching editors to journals based on thematic alignment, ensuring that assignments are made based on expertise.**

```sql
SELECT theme FROM editor_expertise;
```

**Results (CSV format):**
```csv
theme
Science
Arts
Technology
```

**Query 4: Query Description: Retrieve the current assignments of editors to journals. This data represents the decision variables in the optimization model, indicating whether an editor is assigned to a journal.**

```sql
SELECT Assign_ej FROM journal_committee;
```

**Results (CSV format):**
```csv
Assign_ej
1
0
1
```

**Query 5: Query Description: Retrieve the total number of journals assigned to each editor. This aggregated data is useful for ensuring that the workload constraints are respected.**

```sql
SELECT editor_id, COUNT(journal_id) AS Total_Assignments FROM journal_committee GROUP BY editor_id;
```

**Error:** Execution failed on sql 'SELECT editor_id, COUNT(journal_id) AS Total_Assignments FROM journal_committee GROUP BY editor_id;': no such column: editor_id

**Query 6: Query Description: Retrieve the total sales for journals assigned to each editor. This aggregated data helps in understanding the contribution of each editor to the total sales, which is the objective to maximize.**

```sql
SELECT editor_id, SUM(journal.Sales) AS Total_Sales FROM journal_committee JOIN journal ON journal_committee.journal_id = journal.journal_id GROUP BY editor_id;
```

**Error:** Execution failed on sql 'SELECT editor_id, SUM(journal.Sales) AS Total_Sales FROM journal_committee JOIN journal ON journal_committee.journal_id = journal.journal_id GROUP BY editor_id;': no such column: editor_id

**Query 7: Query Description: Retrieve the number of journals each editor can still handle based on their maximum workload. This data is useful for determining the remaining capacity of each editor, ensuring that assignments do not exceed their limits.**

```sql
SELECT editor_workload.editor_id, editor_workload.Max_Workload - COUNT(journal_committee.journal_id) AS Remaining_Capacity FROM editor_workload LEFT JOIN journal_committee ON editor_workload.editor_id = journal_committee.editor_id GROUP BY editor_workload.editor_id, editor_workload.Max_Workload;
```

**Error:** Execution failed on sql 'SELECT editor_workload.editor_id, editor_workload.Max_Workload - COUNT(journal_committee.journal_id) AS Remaining_Capacity FROM editor_workload LEFT JOIN journal_committee ON editor_workload.editor_id = journal_committee.editor_id GROUP BY editor_workload.editor_id, editor_workload.Max_Workload;': no such column: editor_workload.editor_id

**Query 8: Query Description: Retrieve the journals that are not currently assigned to any editor. This data is important for ensuring that the constraint of assigning at least one editor to each journal is met.**

```sql
SELECT journal_id FROM journal WHERE journal_id NOT IN (SELECT journal_id FROM journal_committee WHERE Assign_ej = TRUE);
```

**Error:** Execution failed on sql 'SELECT journal_id FROM journal WHERE journal_id NOT IN (SELECT journal_id FROM journal_committee WHERE Assign_ej = TRUE);': no such column: journal_id

**Query 9: Query Description: Retrieve the thematic alignment between editors and journals. This data is crucial for ensuring that editors are matched to journals based on their expertise, which is a key factor in the optimization process.**

```sql
SELECT editor_expertise.editor_id, journal.journal_id, editor_expertise.theme, journal.theme AS journal_theme, CASE WHEN editor_expertise.theme = journal.theme THEN 1 ELSE 0 END AS thematic_match FROM editor_expertise CROSS JOIN journal;
```

**Error:** Execution failed on sql 'SELECT editor_expertise.editor_id, journal.journal_id, editor_expertise.theme, journal.theme AS journal_theme, CASE WHEN editor_expertise.theme = journal.theme THEN 1 ELSE 0 END AS thematic_match FROM editor_expertise CROSS JOIN journal;': no such column: editor_expertise.editor_id

