# Complete Optimization Problem and Solution: machine_repair

## 1. Problem Context and Goals

### Context  
A repair shop is tasked with efficiently assigning technicians to machine repairs to minimize the total repair time. Each technician has a specific expertise level, and each machine repair has a priority level that determines its urgency. The shop must ensure that each repair is assigned to exactly one technician, that no technician is overloaded beyond their capacity, and that high-priority repairs are addressed first.  

The repair time for each technician and repair combination is calculated based on the technician’s base repair time and the complexity of the machine being repaired. This calculation ensures that the repair time reflects both the technician’s skill and the machine’s difficulty.  

The shop operates under the following business configuration:  
- **Maximum Repairs per Technician**: Each technician can handle a maximum of 5 repairs at a time to prevent overloading and maintain efficiency.  
- **Minimum Priority Level**: Repairs with a priority level of 2 or higher are considered high-priority and must be addressed first.  

The decision to assign a technician to a repair is represented as a binary choice: either the technician is assigned (1) or not (0). This decision directly impacts the total repair time, which is the sum of the repair times for all assigned technician-repair pairs.  

### Goals  
The primary goal of this optimization is to minimize the total repair time across all assigned technician-repair pairs. This is achieved by efficiently assigning technicians to repairs while adhering to the constraints of technician capacity and repair priority. Success is measured by the reduction in total repair time, ensuring that high-priority repairs are completed promptly and that technicians are utilized effectively without exceeding their workload limits.  

## 2. Constraints  

The optimization must adhere to the following constraints:  
1. **Single Assignment per Repair**: Each repair must be assigned to exactly one technician. This ensures that all repairs are addressed without duplication or omission.  
2. **Technician Capacity Limit**: The total number of repairs assigned to a technician must not exceed their maximum capacity. This prevents overloading and maintains operational efficiency.  
3. **Priority Level Requirement**: Repairs with a priority level of 2 or higher must be addressed first. This ensures that high-priority machines are repaired promptly, aligning with business priorities.  

These constraints ensure that the optimization solution is both feasible and aligned with the repair shop’s operational requirements.  

## 3. Available Data  

### Database Schema  
```sql
-- Iteration 1 Database Schema
-- Objective: Schema changes include creating new tables for repair time, technician capacity, and machine priority. Configuration logic updates include scalar parameters for max repairs per technician and min priority, and a formula for repair time calculation.

CREATE TABLE repair_time (
  technician_id INTEGER,
  repair_ID INTEGER,
  repair_time FLOAT
);

CREATE TABLE technician_capacity (
  technician_id INTEGER,
  max_repairs INTEGER
);

CREATE TABLE machine_priority (
  Machine_ID INTEGER,
  priority INTEGER
);

CREATE TABLE repair_assignment (
  technician_id INTEGER,
  repair_ID INTEGER
);
```

### Data Dictionary  
- **repair_time**:  
  - **Business Purpose**: Records the time taken by a technician to complete a specific repair.  
  - **Optimization Role**: Provides the coefficients for the objective function, representing the repair time for each technician-repair pair.  
  - **Columns**:  
    - `technician_id`: Identifier for the technician.  
    - `repair_ID`: Identifier for the repair.  
    - `repair_time`: Time taken to complete the repair.  

- **technician_capacity**:  
  - **Business Purpose**: Specifies the maximum number of repairs each technician can handle.  
  - **Optimization Role**: Provides the bounds for the technician capacity constraint.  
  - **Columns**:  
    - `technician_id`: Identifier for the technician.  
    - `max_repairs`: Maximum number of repairs the technician can handle.  

- **machine_priority**:  
  - **Business Purpose**: Indicates the priority level of each machine repair.  
  - **Optimization Role**: Provides the bounds for the priority constraint.  
  - **Columns**:  
    - `Machine_ID`: Identifier for the machine.  
    - `priority`: Priority level of the machine repair.  

- **repair_assignment**:  
  - **Business Purpose**: Tracks the assignment of technicians to repairs.  
  - **Optimization Role**: Represents the decision variables in the optimization model.  
  - **Columns**:  
    - `technician_id`: Identifier for the technician.  
    - `repair_ID`: Identifier for the repair.  


### Retrieved Values

**Query 1: Importance: This data is crucial for the objective function, as it represents the repair time for each possible assignment.**

```sql
SELECT technician_id, repair_ID, repair_time FROM repair_time;
```

**Results (CSV format):**
```csv
technician_id,repair_ID,repair_time
1,101,2.5
2,102,3.0
3,103,4.0
```

**Query 2: Importance: This data is essential for the technician capacity constraint, ensuring no technician is overloaded.**

```sql
SELECT technician_id, max_repairs FROM technician_capacity;
```

**Results (CSV format):**
```csv
technician_id,max_repairs
1,5
2,4
3,3
```

**Query 3: Importance: This data is necessary for the priority constraint, ensuring high-priority repairs are addressed first.**

```sql
SELECT Machine_ID, priority FROM machine_priority;
```

**Results (CSV format):**
```csv
Machine_ID,priority
201,1
202,2
203,3
```

**Query 4: Importance: This data represents the decision variables in the optimization model, showing which repairs are already assigned to which technicians.**

```sql
SELECT technician_id, repair_ID FROM repair_assignment;
```

**Results (CSV format):**
```csv
technician_id,repair_ID
1,101
2,102
3,103
```

**Query 5: Importance: This aggregated data helps in enforcing the technician capacity constraint by showing how many repairs each technician is already handling.**

```sql
SELECT technician_id, COUNT(repair_ID) AS current_repairs FROM repair_assignment GROUP BY technician_id;
```

**Results (CSV format):**
```csv
technician_id,current_repairs
1,1
2,1
3,1
```

**Query 6: Importance: This filtered data ensures that high-priority repairs are considered first in the optimization process.**

```sql
SELECT Machine_ID, priority FROM machine_priority WHERE priority >= 2;
```

**Results (CSV format):**
```csv
Machine_ID,priority
202,2
203,3
```

**Query 7: Importance: This data helps in focusing the optimization on high-priority repairs, ensuring they are addressed promptly.**

```sql
SELECT rt.technician_id, rt.repair_ID, rt.repair_time FROM repair_time rt JOIN machine_priority mp ON rt.repair_ID = mp.Machine_ID WHERE mp.priority >= 2;
```

**Results (CSV format):**
```csv
technician_id,repair_ID,repair_time
```

**Query 8: Importance: This data is crucial for determining how many additional repairs each technician can handle without exceeding their capacity.**

```sql
SELECT technician_id, COUNT(repair_ID) AS current_repairs FROM repair_assignment GROUP BY technician_id ) cr ON tc.technician_id = cr.technician_id;
```

**Error:** Execution failed on sql 'SELECT technician_id, COUNT(repair_ID) AS current_repairs FROM repair_assignment GROUP BY technician_id ) cr ON tc.technician_id = cr.technician_id;': near ")": syntax error

**Query 9: Importance: This data helps in identifying potential new assignments that can be considered in the optimization process.**

```sql
SELECT rt.technician_id, rt.repair_ID, rt.repair_time FROM repair_time rt LEFT JOIN repair_assignment ra ON rt.technician_id = ra.technician_id AND rt.repair_ID = ra.repair_ID WHERE ra.repair_ID IS NULL;
```

**Results (CSV format):**
```csv
technician_id,repair_ID,repair_time
```

**Query 10: Importance: This data ensures that high-priority repairs are considered first among the unassigned repairs.**

```sql
SELECT rt.technician_id, rt.repair_ID, rt.repair_time FROM repair_time rt JOIN machine_priority mp ON rt.repair_ID = mp.Machine_ID LEFT JOIN repair_assignment ra ON rt.technician_id = ra.technician_id AND rt.repair_ID = ra.repair_ID WHERE mp.priority >= 2 AND ra.repair_ID IS NULL;
```

**Results (CSV format):**
```csv
technician_id,repair_ID,repair_time
```

