# Complete Optimization Problem and Solution: mountain_photos

## 1. Problem Context and Goals

### Context  
A photography company is tasked with selecting the most cost-effective camera lenses for photographing a set of mountains. Each mountain has specific requirements for the minimum focal length and aperture of the lenses used to capture high-quality images. The company must decide which lenses to assign to each mountain, ensuring that the selected lenses meet these technical requirements while minimizing the total cost of the lenses used.  

The decision involves choosing whether to assign a specific lens to a specific mountain, represented as a binary choice (selected or not selected). The company has operational constraints: each mountain must be assigned at least one lens, but no more than three lenses, to balance flexibility and cost efficiency. These constraints are defined by the business configuration parameters, which specify the minimum and maximum number of lenses that can be used per mountain.  

The cost of each lens is a key factor in the decision-making process, as the company aims to minimize the total expenditure on lenses while ensuring that all technical requirements are met. The focal length and aperture of each lens must be equal to or greater than the minimum requirements specified for each mountain.  

### Goals  
The primary goal of this optimization problem is to minimize the total cost of the lenses selected for photographing the mountains. This is achieved by carefully choosing which lenses to assign to each mountain, ensuring that the selected lenses meet the technical requirements and that the total number of lenses used per mountain falls within the specified bounds. Success is measured by the ability to achieve the lowest possible total cost while adhering to all operational and technical constraints.  

## 2. Constraints  

The optimization problem is subject to the following constraints:  
1. **Minimum Lenses per Mountain**: Each mountain must be assigned at least one lens to ensure that the photography requirements are met.  
2. **Maximum Lenses per Mountain**: No mountain can be assigned more than three lenses to prevent excessive costs and maintain operational efficiency.  
3. **Focal Length Requirement**: For each lens assigned to a mountain, the focal length of the lens must be equal to or greater than the minimum focal length required for that mountain.  
4. **Aperture Requirement**: For each lens assigned to a mountain, the maximum aperture of the lens must be equal to or greater than the minimum aperture required for that mountain.  

These constraints ensure that the lens selection process is both technically feasible and operationally efficient, aligning with the company’s goal of minimizing costs while meeting all photography requirements.  

## 3. Available Data  

### Database Schema  
```sql
-- Iteration 2 Database Schema
-- Objective: Refined schema to include a new table for lens-mountain selection, updated business configuration logic, and ensured proper mapping for decision variables.

CREATE TABLE lenses (
  lens_id INTEGER,
  cost FLOAT,
  focal_length_mm INTEGER,
  max_aperture FLOAT
);

CREATE TABLE mountains (
  mountain_id INTEGER,
  minimum_focal_length INTEGER,
  minimum_aperture FLOAT
);

CREATE TABLE lens_mountain_selection (
  lens_id INTEGER,
  mountain_id INTEGER,
  selected BOOLEAN
);
```

### Data Dictionary  
- **Lenses Table**:  
  - **lens_id**: Unique identifier for each camera lens.  
  - **cost**: The cost of the lens, used to calculate the total expenditure in the optimization objective.  
  - **focal_length_mm**: The focal length of the lens in millimeters, used to ensure it meets the minimum requirement for each mountain.  
  - **max_aperture**: The maximum aperture of the lens, used to ensure it meets the minimum requirement for each mountain.  

- **Mountains Table**:  
  - **mountain_id**: Unique identifier for each mountain.  
  - **minimum_focal_length**: The minimum focal length required for photographing the mountain.  
  - **minimum_aperture**: The minimum aperture required for photographing the mountain.  

- **Lens-Mountain Selection Table**:  
  - **lens_id**: Identifier for the lens being considered for selection.  
  - **mountain_id**: Identifier for the mountain to which the lens is being assigned.  
  - **selected**: A binary indicator (True/False) representing whether the lens is selected for the mountain.  


### Retrieved Values

**Query 1: This data is essential for the objective function (minimizing cost) and for checking technical requirements (focal length and aperture).**

```sql
SELECT lens_id, cost, focal_length_mm, max_aperture FROM lenses;
```

**Results (CSV format):**
```csv
lens_id,cost,focal_length_mm,max_aperture
1,500.0,24,1.8
2,750.0,50,2.8
3,1000.0,85,4.0
```

**Query 2: This data is crucial for ensuring that the selected lenses meet the technical requirements for each mountain.**

```sql
SELECT mountain_id, minimum_focal_length, minimum_aperture FROM mountains;
```

**Results (CSV format):**
```csv
mountain_id,minimum_focal_length,minimum_aperture
1,24,1.8
2,50,2.8
3,85,4.0
```

**Query 3: This query helps in identifying feasible lens-mountain assignments, which is a key step in the optimization process.**

```sql
SELECT l.lens_id, m.mountain_id, l.cost, l.focal_length_mm, l.max_aperture, m.minimum_focal_length, m.minimum_aperture FROM lenses l JOIN mountains m ON l.focal_length_mm >= m.minimum_focal_length AND l.max_aperture >= m.minimum_aperture;
```

**Results (CSV format):**
```csv
lens_id,mountain_id,cost,focal_length_mm,max_aperture,minimum_focal_length,minimum_aperture
1,1,500.0,24,1.8,24,1.8
2,1,750.0,50,2.8,24,1.8
2,2,750.0,50,2.8,50,2.8
3,1,1000.0,85,4.0,24,1.8
3,2,1000.0,85,4.0,50,2.8
3,3,1000.0,85,4.0,85,4.0
```

**Query 4: This data is important for understanding the current state of assignments and for ensuring that the constraints on the number of lenses per mountain are met.**

```sql
SELECT lens_id, mountain_id, selected FROM lens_mountain_selection;
```

**Results (CSV format):**
```csv
lens_id,mountain_id,selected
1,1,1
2,2,1
3,3,1
```

**Query 5: This query helps in enforcing the constraints on the minimum and maximum number of lenses per mountain.**

```sql
SELECT mountain_id, COUNT(lens_id) AS num_lenses FROM lens_mountain_selection WHERE selected = TRUE GROUP BY mountain_id;
```

**Results (CSV format):**
```csv
mountain_id,num_lenses
1,1
2,1
3,1
```

**Query 6: This query is useful for evaluating the current total cost and for the objective function in the optimization problem.**

```sql
SELECT SUM(l.cost) AS total_cost FROM lens_mountain_selection lms JOIN lenses l ON lms.lens_id = l.lens_id WHERE lms.selected = TRUE;
```

**Results (CSV format):**
```csv
total_cost
2250.0
```

**Query 7: This query helps in identifying mountains that do not meet the minimum lens assignment constraint.**

```sql
SELECT mountain_id FROM lens_mountain_selection WHERE selected = TRUE GROUP BY mountain_id HAVING COUNT(lens_id) < 1;
```

**Results (CSV format):**
```csv
mountain_id
```

**Query 8: This query helps in identifying mountains that exceed the maximum lens assignment constraint.**

```sql
SELECT mountain_id FROM lens_mountain_selection WHERE selected = TRUE GROUP BY mountain_id HAVING COUNT(lens_id) > 3;
```

**Results (CSV format):**
```csv
mountain_id
```

**Query 9: This query helps in identifying available lenses that can be considered for assignment to meet the constraints.**

```sql
SELECT l.lens_id FROM lenses l LEFT JOIN lens_mountain_selection lms ON l.lens_id = lms.lens_id AND lms.selected = TRUE WHERE lms.lens_id IS NULL;
```

**Results (CSV format):**
```csv
lens_id
```

**Query 10: This query helps in identifying mountains that still need to have lenses assigned to meet the minimum requirement.**

```sql
SELECT m.mountain_id FROM mountains m LEFT JOIN lens_mountain_selection lms ON m.mountain_id = lms.mountain_id AND lms.selected = TRUE WHERE lms.mountain_id IS NULL;
```

**Results (CSV format):**
```csv
mountain_id
```

