# Complete Optimization Problem and Solution: network_2

## 1. Problem Context and Goals

### Context  
The social network aims to maximize the number of friendships formed among its users while ensuring a balanced and inclusive network. Each user can form friendships with others, but the network enforces specific rules to maintain balance and prevent overloading any single user. 

Key operational parameters include:  
- **Maximum number of friendships per person**: Each user is allowed to have up to 15 friendships. This ensures that no single user is overwhelmed with too many connections.  
- **Minimum number of friendships per age group**: Each user must have at least 3 friendships with users from different age groups. This promotes diversity and inclusivity across the network.  

The network also ensures that friendships are mutual, meaning if person i is friends with person j, then person j must also be friends with person i. This mutual relationship is a fundamental requirement for all friendships in the network.  

The goal is to maximize the total number of friendships while adhering to these constraints, ensuring a balanced and sustainable social network.

### Goals  
The primary optimization goal is to maximize the total number of friendships formed across the network. Success is measured by the total count of friendships, ensuring that the network grows while maintaining balance and inclusivity.  

The network aims to achieve this by:  
- Encouraging as many friendships as possible within the allowed limits.  
- Ensuring that each user has a minimum number of friendships across different age groups.  
- Maintaining mutual friendships to foster genuine connections.  

This goal aligns with the operational parameters and ensures that the network remains diverse, inclusive, and scalable.

## 2. Constraints  

The optimization problem is subject to the following constraints:  
1. **Minimum friendships per age group**: Each user must have at least 3 friendships with users from each defined age group. This ensures that users have diverse connections across different age ranges.  
2. **Maximum friendships per person**: No user can have more than 15 friendships. This prevents any single user from being overwhelmed with too many connections.  
3. **Mutual friendships**: If person i is friends with person j, then person j must also be friends with person i. This ensures that all friendships are mutual and genuine.  

These constraints ensure that the network remains balanced, inclusive, and sustainable while maximizing the total number of friendships.

## 3. Available Data  

### Database Schema  
```sql
-- Iteration 1 Database Schema
-- Objective: Schema changes include creating tables for decision variables, age groups, and friendships. Configuration logic updates include scalar parameters for max friendships per person and min friendships per age group, and a formula for friendship balance.

CREATE TABLE friendships (
  person_i INTEGER,
  person_j INTEGER,
  is_friends BOOLEAN
);

CREATE TABLE age_groups (
  age_group_id INTEGER,
  age_range STRING
);
```

### Data Dictionary  
- **Friendships Table**:  
  - **Purpose**: Tracks whether a friendship exists between two users.  
  - **Columns**:  
    - `person_i`: The ID of the first user in the friendship.  
    - `person_j`: The ID of the second user in the friendship.  
    - `is_friends`: Indicates whether the two users are friends (True or False).  

- **Age Groups Table**:  
  - **Purpose**: Defines the age groups used to ensure balanced friendships across different age ranges.  
  - **Columns**:  
    - `age_group_id`: The ID of the age group.  
    - `age_range`: The age range for the group (e.g., 18-25, 26-35).  


### Retrieved Values

**Query 1: This is important for the optimization problem as it provides the baseline data on which to build new friendships.**

```sql
SELECT person_i, person_j, is_friends FROM friendships WHERE is_friends = TRUE;
```

**Results (CSV format):**
```csv
person_i,person_j,is_friends
1,2,1
2,3,1
3,4,1
```

**Query 2: This is crucial for enforcing the constraint that no user can have more than 15 friendships.**

```sql
SELECT person_i, COUNT(*) AS friendship_count FROM friendships WHERE is_friends = TRUE GROUP BY person_i HAVING COUNT(*) > 15;
```

**Results (CSV format):**
```csv
person_i,friendship_count
```

**Query 3: Additional tables or columns would be needed to fully implement this query.**

```sql
SELECT person_i, age_group_id, COUNT(*) AS age_group_friendship_count FROM friendships JOIN age_groups ON ... -- Assuming a join condition exists to map users to age groups WHERE is_friends = TRUE GROUP BY person_i, age_group_id HAVING COUNT(*) < 3;
```

**Error:** Execution failed on sql 'SELECT person_i, age_group_id, COUNT(*) AS age_group_friendship_count FROM friendships JOIN age_groups ON ... -- Assuming a join condition exists to map users to age groups WHERE is_friends = TRUE GROUP BY person_i, age_group_id HAVING COUNT(*) < 3;': near ".": syntax error

**Query 4: This is important for identifying opportunities to form new friendships while maximizing the total number of friendships.**

```sql
SELECT person_i, person_j FROM friendships WHERE is_friends = FALSE;
```

**Results (CSV format):**
```csv
person_i,person_j
1,3
4,5
```

**Query 5: This is important for measuring the success of the optimization goal, which is to maximize the total number of friendships.**

```sql
SELECT COUNT(*) AS total_friendships FROM friendships WHERE is_friends = TRUE;
```

**Results (CSV format):**
```csv
total_friendships
3
```

**Query 6: This is important for understanding the different age groups that need to be considered for the minimum friendships per age group constraint.**

```sql
SELECT age_group_id, age_range FROM age_groups;
```

**Results (CSV format):**
```csv
age_group_id,age_range
1,-7
2,-9
3,-9
```

**Query 7: Additional tables or columns would be needed to fully implement this query.**

```sql
SELECT age_group_id, COUNT(*) AS user_count FROM users JOIN age_groups ON ... -- Assuming a join condition exists to map users to age groups GROUP BY age_group_id;
```

**Error:** Execution failed on sql 'SELECT age_group_id, COUNT(*) AS user_count FROM users JOIN age_groups ON ... -- Assuming a join condition exists to map users to age groups GROUP BY age_group_id;': near ".": syntax error

**Query 8: This is important for enforcing the constraint that if person i is friends with person j, then person j must also be friends with person i.**

```sql
SELECT f1.person_i, f1.person_j FROM friendships f1 JOIN friendships f2 ON f1.person_i = f2.person_j AND f1.person_j = f2.person_i WHERE f1.is_friends = TRUE AND f2.is_friends = TRUE;
```

**Results (CSV format):**
```csv
person_i,person_j
```

**Query 9: Additional tables or columns would be needed to fully implement this query.**

```sql
SELECT person_i FROM friendships JOIN age_groups ON ... -- Assuming a join condition exists to map users to age groups WHERE is_friends = TRUE GROUP BY person_i, age_group_id HAVING COUNT(*) < 3;
```

**Error:** Execution failed on sql 'SELECT person_i FROM friendships JOIN age_groups ON ... -- Assuming a join condition exists to map users to age groups WHERE is_friends = TRUE GROUP BY person_i, age_group_id HAVING COUNT(*) < 3;': near ".": syntax error

