# Complete Optimization Problem and Solution: news_report

## 1. Problem Context and Goals

### Context  
A news agency is tasked with optimizing the assignment of journalists to events to maximize the overall quality of coverage. The quality of coverage is determined by the journalist's years of experience and the attendance of the event they are assigned to. Each event must be covered by at least one journalist, and no journalist can be assigned to more than a specified number of events, as defined by the business configuration. The decision to assign a journalist to an event is represented as a binary choice, ensuring a clear and linear relationship between the decision variables and the objective. The coverage quality is calculated as the product of the journalist's years of experience and the event's attendance, which directly contributes to the linear objective function. This setup ensures that the optimization problem remains linear, avoiding any nonlinear relationships such as variable products or divisions.

### Goals  
The primary goal of this optimization problem is to maximize the total coverage quality across all events. This is achieved by strategically assigning journalists to events in a way that leverages their experience and the significance of the event, as measured by attendance. Success is measured by the sum of the coverage quality scores for all assignments, where each score is the product of the journalist's years of experience and the event's attendance. The optimization process ensures that the assignments are made within the constraints of each journalist's maximum allowable number of event assignments, maintaining a balanced and efficient allocation of resources.

## 2. Constraints    

1. **Event Coverage Requirement**: Each event must be covered by at least one journalist. This ensures that all events receive adequate coverage, and no event is left unattended.  
2. **Journalist Assignment Limit**: No journalist can be assigned to more than the maximum number of events specified in the business configuration. This prevents overburdening journalists and ensures a fair distribution of assignments.  

These constraints are designed to maintain operational feasibility while aligning with the linear structure of the optimization problem. They ensure that the assignments are both comprehensive and balanced, without introducing any nonlinear complexities.

## 3. Available Data  

### Database Schema  
```sql
-- Iteration 1 Database Schema
-- Objective: Schema changes include creating a new table for journalist-event assignments and adding a column for maximum assignments per journalist. Configuration logic updates include adding scalar parameters for maximum assignments and a formula for coverage quality calculation.

CREATE TABLE journalist (
  Years_working INTEGER,
  max_assignments INTEGER
);

CREATE TABLE event (
  Event_Attendance INTEGER
);

CREATE TABLE journalist_event_assignment (
  assignment BOOLEAN
);
```

### Data Dictionary  
- **Journalist Table**:  
  - **Years_working**: Represents the number of years a journalist has been working. This value is used to calculate the coverage quality score.  
  - **max_assignments**: Specifies the maximum number of events a journalist can be assigned to, ensuring balanced workloads.  

- **Event Table**:  
  - **Event_Attendance**: Represents the number of attendees at an event. This value is used to calculate the coverage quality score.  

- **Journalist_Event_Assignment Table**:  
  - **assignment**: A binary indicator (0 or 1) that determines whether a journalist is assigned to a specific event. This is the decision variable in the optimization problem.  


### Retrieved Values

**Query 1: This data is crucial for determining the objective function coefficients (years of experience) and the constraint parameters (max_assignments).**

```sql
SELECT Years_working, max_assignments FROM journalist;
```

**Results (CSV format):**
```csv
Years_working,max_assignments
5,3
10,4
15,5
```

**Query 2: This data is essential for calculating the coverage quality score, which is a product of the journalist's years of experience and the event's attendance.**

```sql
SELECT Event_Attendance FROM event;
```

**Results (CSV format):**
```csv
Event_Attendance
100
200
300
```

**Query 3: This data is necessary to understand the current state of assignments and to ensure that the constraints (event coverage requirement and journalist assignment limit) are met.**

```sql
SELECT assignment FROM journalist_event_assignment;
```

**Results (CSV format):**
```csv
assignment
0
1
0
```

**Query 4: This aggregated data helps in enforcing the constraint that no journalist can be assigned to more than their maximum number of events.**

```sql
SELECT journalist_id, COUNT(*) AS total_assignments FROM journalist_event_assignment WHERE assignment = 1 GROUP BY journalist_id;
```

**Error:** Execution failed on sql 'SELECT journalist_id, COUNT(*) AS total_assignments FROM journalist_event_assignment WHERE assignment = 1 GROUP BY journalist_id;': no such column: journalist_id

**Query 5: This aggregated data ensures that the constraint of each event being covered by at least one journalist is met.**

```sql
SELECT event_id, COUNT(*) AS total_journalists FROM journalist_event_assignment WHERE assignment = 1 GROUP BY event_id;
```

**Error:** Execution failed on sql 'SELECT event_id, COUNT(*) AS total_journalists FROM journalist_event_assignment WHERE assignment = 1 GROUP BY event_id;': no such column: event_id

**Query 6: This data is crucial for the objective function, as it represents the product of the journalist's years of experience and the event's attendance, which is to be maximized.**

```sql
SELECT j.Years_working * e.Event_Attendance AS coverage_quality FROM journalist j CROSS JOIN event e;
```

**Results (CSV format):**
```csv
coverage_quality
500
1000
1500
1000
2000
3000
1500
3000
4500
```

**Query 7: This data is important for identifying which journalists are still available for additional assignments, ensuring that the journalist assignment limit constraint is not violated.**

```sql
SELECT j.Years_working, j.max_assignments, COUNT(jea.assignment) AS current_assignments FROM journalist j LEFT JOIN journalist_event_assignment jea ON j.journalist_id = jea.journalist_id AND jea.assignment = 1 GROUP BY j.journalist_id HAVING COUNT(jea.assignment) < j.max_assignments;
```

**Error:** Execution failed on sql 'SELECT j.Years_working, j.max_assignments, COUNT(jea.assignment) AS current_assignments FROM journalist j LEFT JOIN journalist_event_assignment jea ON j.journalist_id = jea.journalist_id AND jea.assignment = 1 GROUP BY j.journalist_id HAVING COUNT(jea.assignment) < j.max_assignments;': no such column: j.journalist_id

**Query 8: This data is important for ensuring that the event coverage requirement constraint is met, by identifying events that still need to be assigned to journalists.**

```sql
SELECT e.event_id FROM event e LEFT JOIN journalist_event_assignment jea ON e.event_id = jea.event_id AND jea.assignment = 1 WHERE jea.assignment IS NULL;
```

**Error:** Execution failed on sql 'SELECT e.event_id FROM event e LEFT JOIN journalist_event_assignment jea ON e.event_id = jea.event_id AND jea.assignment = 1 WHERE jea.assignment IS NULL;': no such column: e.event_id

