# Complete Optimization Problem and Solution: party_people

## 1. Problem Context and Goals

### Context  
A political party is focused on maximizing its influence across various regions by strategically allocating its members to events. The party aims to ensure that each region is adequately represented while keeping the total cost of organizing these events within a predefined budget. The influence in each region is directly proportional to the number of members assigned to events in that region, and the cost is determined by the number of events organized. 

The party has a total budget of 150,000 units available for organizing events, and the cost of organizing a single event in any region is 6,000 units. Each region has specific constraints on the number of members that can be assigned, the minimum and maximum number of events that can be organized, and the minimum number of members that must be assigned. The impact of assigning a member to an event varies by region, as reflected by the influence coefficient for each region.

The key decisions involve determining the number of members to assign to events in each region and the number of events to organize in each region. These decisions must respect the budget, regional member availability, and event organization limits.

### Goals  
The primary goal is to maximize the party's overall influence across all regions. This is achieved by strategically assigning members to events in each region, weighted by the region-specific influence coefficient. Success is measured by the total influence generated, which is the sum of the influence coefficients multiplied by the number of members assigned in each region. The optimization ensures that the total cost of organizing events does not exceed the available budget and that all regional constraints on member assignments and event organization are satisfied.

## 2. Constraints  

The optimization problem is subject to the following constraints:  
1. **Budget Constraint**: The total cost of organizing events across all regions must not exceed the total budget of 150,000 units. The cost per event is 6,000 units.  
2. **Member Assignment Upper Bound**: The number of members assigned to events in each region cannot exceed the total number of members available in that region.  
3. **Member Assignment Lower Bound**: Each region must have at least a minimum number of members assigned to events.  
4. **Event Organization Upper Bound**: The number of events organized in each region cannot exceed the maximum number of events allowed in that region.  
5. **Event Organization Lower Bound**: Each region must organize at least a minimum number of events.  

These constraints ensure that the party's operations are feasible, respect resource limitations, and meet regional requirements.

## 3. Available Data  

### Database Schema  
```sql
-- Iteration 1 Database Schema
-- Objective: Schema changes include creating new tables for decision variables and constraint bounds, and updating business configuration logic for scalar parameters and formulas.

CREATE TABLE region_members (
  region_id INTEGER,
  number_of_members INTEGER
);

CREATE TABLE region_events (
  region_id INTEGER,
  number_of_events INTEGER
);

CREATE TABLE region_constraints (
  region_id INTEGER,
  total_members_available INTEGER,
  max_events INTEGER,
  min_members INTEGER,
  min_events INTEGER,
  influence_coefficient FLOAT
);
```

### Data Dictionary  
- **region_members**:  
  - **region_id**: Unique identifier for the region.  
  - **number_of_members**: Number of members assigned to events in the region. This is a decision variable in the optimization.  

- **region_events**:  
  - **region_id**: Unique identifier for the region.  
  - **number_of_events**: Number of events organized in the region. This is a decision variable in the optimization.  

- **region_constraints**:  
  - **region_id**: Unique identifier for the region.  
  - **total_members_available**: Total number of members available in the region. This serves as an upper bound for member assignments.  
  - **max_events**: Maximum number of events that can be organized in the region. This serves as an upper bound for event organization.  
  - **min_members**: Minimum number of members that must be assigned to the region. This serves as a lower bound for member assignments.  
  - **min_events**: Minimum number of events that must be organized in the region. This serves as a lower bound for event organization.  
  - **influence_coefficient**: Impact of assigning a member to an event in the region. This is used as a coefficient in the objective function to measure influence.  


### Retrieved Values

**Query 1: Query Description: Retrieve the total number of members assigned to events and the number of events organized in each region. This data is crucial as it represents the decision variables that need to be optimized.**

```sql
SELECT rm.region_id, rm.number_of_members, re.number_of_events FROM region_members rm JOIN region_events re ON rm.region_id = re.region_id;
```

**Results (CSV format):**
```csv
region_id,number_of_members,number_of_events
1,15,3
2,20,4
3,10,2
```

**Query 2: Query Description: Retrieve the influence coefficient for each region. This data is essential for the objective function as it weights the influence of assigning members to events in each region.**

```sql
SELECT region_id, influence_coefficient FROM region_constraints;
```

**Results (CSV format):**
```csv
region_id,influence_coefficient
1,0.6
2,0.7
3,0.5
```

**Query 3: Query Description: Retrieve the total members available, maximum and minimum number of events, and minimum number of members for each region. This data is necessary to enforce the constraints on member assignments and event organization.**

```sql
SELECT region_id, total_members_available, max_events, min_members, min_events FROM region_constraints;
```

**Results (CSV format):**
```csv
region_id,total_members_available,max_events,min_members,min_events
1,20,5,5,1
2,25,6,6,2
3,15,4,4,1
```

**Query 4: Query Description: Calculate the total cost of organizing events across all regions. This is important to ensure that the budget constraint is not exceeded.**

```sql
SELECT SUM(re.number_of_events) * 6000 AS total_cost FROM region_events re;
```

**Results (CSV format):**
```csv
total_cost
54000
```

**Query 5: Query Description: Retrieve the total number of members assigned to events across all regions. This helps in understanding the overall member allocation and ensuring that it does not exceed the total available members.**

```sql
SELECT SUM(rm.number_of_members) AS total_members_assigned FROM region_members rm;
```

**Results (CSV format):**
```csv
total_members_assigned
45
```

**Query 6: Query Description: Retrieve the number of events organized in each region along with the region's constraints on the minimum and maximum number of events. This helps in ensuring that the event organization constraints are satisfied.**

```sql
SELECT re.region_id, re.number_of_events, rc.min_events, rc.max_events FROM region_events re JOIN region_constraints rc ON re.region_id = rc.region_id;
```

**Results (CSV format):**
```csv
region_id,number_of_events,min_events,max_events
1,3,1,5
2,4,2,6
3,2,1,4
```

**Query 7: Query Description: Retrieve the number of members assigned to events in each region along with the region's constraints on the minimum and maximum number of members. This helps in ensuring that the member assignment constraints are satisfied.**

```sql
SELECT rm.region_id, rm.number_of_members, rc.min_members, rc.total_members_available FROM region_members rm JOIN region_constraints rc ON rm.region_id = rc.region_id;
```

**Results (CSV format):**
```csv
region_id,number_of_members,min_members,total_members_available
1,15,5,20
2,20,6,25
3,10,4,15
```

**Query 8: Query Description: Calculate the total influence generated across all regions. This is the objective function value that needs to be maximized.**

```sql
SELECT SUM(rm.number_of_members * rc.influence_coefficient) AS total_influence FROM region_members rm JOIN region_constraints rc ON rm.region_id = rc.region_id;
```

**Results (CSV format):**
```csv
total_influence
28.0
```

