# Complete Optimization Problem and Solution: performance_attendance

## 1. Problem Context and Goals

### Context  
A music ensemble is focused on optimizing the number of pieces each member performs across various performances to maximize overall attendance. The ensemble must make decisions about how many pieces each member should perform in each performance, ensuring that these decisions align with the goal of attracting the largest possible audience. The attendance for each performance is a key factor in this optimization, as it directly influences the overall success of the ensemble's performances.  

The ensemble operates under specific constraints: each member has a maximum number of pieces they can perform, and each performance has a maximum number of pieces that can be included. Additionally, every member must perform at least one piece to ensure fair participation. The attendance for each performance is a known value and is used to weight the importance of each performance in the optimization process.  

The business configuration includes a scalar parameter for attendance, which represents the average attendance across performances. This parameter simplifies the objective function by providing a consistent measure of attendance impact.  

### Goals  
The primary goal of this optimization is to maximize the total attendance across all performances by strategically assigning the number of pieces each member performs. Success is measured by the overall attendance achieved, which is directly influenced by the number of pieces performed by each member in each performance. The optimization ensures that the ensemble's performances are as attractive as possible to the audience while respecting the operational constraints of the members and performances.  

## 2. Constraints  

The optimization must adhere to the following constraints:  
1. **Maximum Pieces per Member**: Each member cannot perform more than a specified maximum number of pieces across all performances. This ensures that no member is overburdened.  
2. **Maximum Pieces per Performance**: Each performance cannot include more than a specified maximum number of pieces. This ensures that performances remain manageable and focused.  
3. **Minimum Pieces per Member**: Each member must perform at least one piece across all performances. This ensures fair participation and engagement from all members.  

These constraints are designed to maintain operational feasibility while achieving the optimization goal.  

## 3. Available Data  

### Database Schema  
```sql
-- Iteration 2 Database Schema
-- Objective: Added attendance_data table to capture attendance per performance, updated business configuration logic with attendance-related scalar parameters, and ensured all mappings align with OR expert requirements.

CREATE TABLE member_constraints (
  member_id INTEGER,
  max_pieces INTEGER
);

CREATE TABLE performance_constraints (
  performance_id INTEGER,
  max_pieces INTEGER
);

CREATE TABLE member_attendance (
  member_id INTEGER,
  performance_id INTEGER,
  num_of_pieces INTEGER
);

CREATE TABLE attendance_data (
  performance_id INTEGER,
  attendance INTEGER
);
```

### Data Dictionary  
- **member_constraints**:  
  - **member_id**: Unique identifier for each member.  
  - **max_pieces**: Maximum number of pieces the member can perform across all performances.  

- **performance_constraints**:  
  - **performance_id**: Unique identifier for each performance.  
  - **max_pieces**: Maximum number of pieces allowed in the performance.  

- **member_attendance**:  
  - **member_id**: Unique identifier for each member.  
  - **performance_id**: Unique identifier for each performance.  
  - **num_of_pieces**: Number of pieces the member performs in the performance.  

- **attendance_data**:  
  - **performance_id**: Unique identifier for each performance.  
  - **attendance**: Attendance for the performance, used to weight the importance of the performance in the optimization.  


### Retrieved Values

**Query 1: This is crucial for the constraint that ensures no member is overburdened.**

```sql
SELECT member_id, max_pieces FROM member_constraints;
```

**Results (CSV format):**
```csv
member_id,max_pieces
1,5
2,4
3,3
```

**Query 2: This is essential for the constraint that ensures performances remain manageable and focused.**

```sql
SELECT performance_id, max_pieces FROM performance_constraints;
```

**Results (CSV format):**
```csv
performance_id,max_pieces
1,10
2,8
3,6
```

**Query 3: This data is needed to understand the current distribution of pieces and to optimize the assignment.**

```sql
SELECT member_id, performance_id, num_of_pieces FROM member_attendance;
```

**Results (CSV format):**
```csv
member_id,performance_id,num_of_pieces
1,1,3
2,1,2
3,1,1
```

**Query 4: This data is used to weight the importance of each performance in the optimization process.**

```sql
SELECT performance_id, attendance FROM attendance_data;
```

**Results (CSV format):**
```csv
performance_id,attendance
1,200
2,150
3,100
```

**Query 5: This helps in ensuring that the minimum pieces per member constraint is met and that the maximum pieces per member constraint is not exceeded.**

```sql
SELECT member_id, SUM(num_of_pieces) AS total_pieces FROM member_attendance GROUP BY member_id;
```

**Results (CSV format):**
```csv
member_id,total_pieces
1,3
2,2
3,1
```

**Query 6: This helps in ensuring that the maximum pieces per performance constraint is not exceeded.**

```sql
SELECT performance_id, SUM(num_of_pieces) AS total_pieces FROM member_attendance GROUP BY performance_id;
```

**Results (CSV format):**
```csv
performance_id,total_pieces
1,6
```

**Query 7: This data is useful for the objective function, as it combines the number of pieces with the attendance to maximize overall attendance.**

```sql
SELECT ma.member_id, ma.performance_id, ma.num_of_pieces, ad.attendance FROM member_attendance ma JOIN attendance_data ad ON ma.performance_id = ad.performance_id;
```

**Results (CSV format):**
```csv
member_id,performance_id,num_of_pieces,attendance
1,1,3,200
2,1,2,200
3,1,1,200
```

**Query 8: This scalar parameter simplifies the objective function by providing a consistent measure of attendance impact.**

```sql
SELECT AVG(attendance) AS avg_attendance FROM attendance_data;
```

**Results (CSV format):**
```csv
avg_attendance
150.0
```

**Query 9: This is the primary metric to maximize in the optimization process.**

```sql
SELECT SUM(attendance) AS total_attendance FROM attendance_data;
```

**Results (CSV format):**
```csv
total_attendance
450
```

**Query 10: This helps in ensuring that each member performs at least one piece across all performances.**

```sql
SELECT member_id, COUNT(DISTINCT performance_id) AS num_performances FROM member_attendance GROUP BY member_id;
```

**Results (CSV format):**
```csv
member_id,num_performances
1,1
2,1
3,1
```

**Query 11: This helps in understanding the distribution of members across performances and ensuring that performances are well-balanced.**

```sql
SELECT performance_id, COUNT(DISTINCT member_id) AS num_members FROM member_attendance GROUP BY performance_id;
```

**Results (CSV format):**
```csv
performance_id,num_members
1,3
```

