# Complete Optimization Problem and Solution: perpetrator

## 1. Problem Context and Goals

### Context  
A security agency is tasked with minimizing the total number of casualties (both killed and injured) across various locations by strategically allocating its limited resources. The agency must decide how many resources to assign to each location to effectively monitor and prevent incidents. Historical data indicates that the allocation of resources directly impacts the reduction of casualties in each location. The agency operates under two critical operational constraints:  
1. The total number of resources available for allocation is fixed and cannot be exceeded.  
2. Each location has a maximum allowable number of casualties, which must not be surpassed.  

The agency’s decision-making process focuses on determining the optimal number of resources to allocate to each location, ensuring that the total resources used do not exceed the available capacity and that the casualties in each location remain within the predefined safety limits. This problem is inherently linear, as the relationships between resource allocation, casualties, and constraints are proportional and additive, without any nonlinear interactions such as variable products or divisions.

### Goals  
The primary goal of the agency is to minimize the total number of casualties across all locations. This is achieved by optimizing the allocation of resources to each location, ensuring that the sum of killed and injured individuals is as low as possible. Success is measured by the reduction in casualties, which is directly influenced by the effective distribution of resources. The agency aims to achieve this goal while adhering to the operational constraints of total resource availability and maximum allowable casualties per location.

## 2. Constraints  

The agency’s optimization problem is subject to the following constraints:  
1. **Total Resource Constraint**: The sum of resources allocated to all locations must not exceed the total number of resources available. This ensures that the agency does not overcommit its limited resources.  
2. **Maximum Casualties Constraint**: For each location, the sum of killed and injured individuals must not exceed the maximum allowed casualties. This ensures that safety thresholds are maintained in every location.  

These constraints are linear and proportional, ensuring that the optimization problem remains straightforward and solvable using linear methods.

## 3. Available Data  

### Database Schema  
```sql
-- Iteration 3 Database Schema
-- Objective: Added missing scalar parameters to business configuration logic, ensured schema follows normalization principles, and updated data dictionary to reflect changes.

CREATE TABLE ResourceAllocation (
  location_id INTEGER,
  resources_allocated FLOAT
);

CREATE TABLE Casualties (
  location_id INTEGER,
  killed INTEGER,
  injured INTEGER
);
```

### Data Dictionary  
- **ResourceAllocation Table**:  
  - **location_id**: A unique identifier for each location where resources are allocated.  
  - **resources_allocated**: The number of resources assigned to a specific location. This is the decision variable in the optimization problem.  

- **Casualties Table**:  
  - **location_id**: A unique identifier for each location where casualties are recorded.  
  - **killed**: The number of individuals killed in a specific location. This is a coefficient in the optimization objective.  
  - **injured**: The number of individuals injured in a specific location. This is a coefficient in the optimization objective.  


### Retrieved Values

**Query 1: This is crucial for the Total Resource Constraint, ensuring that the sum of resources allocated does not exceed the available resources.**

```sql
SELECT SUM(resources_allocated) AS total_resources_available FROM ResourceAllocation;
```

**Results (CSV format):**
```csv
total_resources_available
45.0
```

**Query 2: This data is essential for the Maximum Casualties Constraint, ensuring that the sum of casualties in each location does not exceed the predefined safety limits.**

```sql
SELECT location_id, (killed + injured) AS total_casualties FROM Casualties;
```

**Results (CSV format):**
```csv
location_id,total_casualties
1,30
2,18
3,11
```

**Query 3: This data is necessary to understand the current distribution of resources, which is the decision variable in the optimization problem.**

```sql
SELECT location_id, resources_allocated FROM ResourceAllocation;
```

**Results (CSV format):**
```csv
location_id,resources_allocated
1,20.0
2,15.0
3,10.0
```

**Query 4: This data is important for the objective function, which aims to minimize the total number of casualties.**

```sql
SELECT SUM(killed + injured) AS total_casualties FROM Casualties;
```

**Results (CSV format):**
```csv
total_casualties
59
```

**Query 5: Example: Assuming a table named 'LocationConstraints' with columns 'location_id' and 'max_casualties'.**

```sql
SELECT location_id, max_casualties FROM LocationConstraints;
```

**Error:** Execution failed on sql 'SELECT location_id, max_casualties FROM LocationConstraints;': no such table: LocationConstraints

**Query 6: This data is important for understanding how resource allocation impacts casualties, which is key to optimizing the allocation.**

```sql
SELECT ra.location_id, ra.resources_allocated, c.killed, c.injured FROM ResourceAllocation ra JOIN Casualties c ON ra.location_id = c.location_id;
```

**Results (CSV format):**
```csv
location_id,resources_allocated,killed,injured
1,20.0,5,25
2,15.0,3,15
3,10.0,1,10
```

**Query 7: This data can help in understanding the efficiency of resource allocation in reducing casualties, which is useful for optimization.**

```sql
SELECT ra.location_id, AVG(c.killed + c.injured) / ra.resources_allocated AS casualties_per_resource FROM ResourceAllocation ra JOIN Casualties c ON ra.location_id = c.location_id GROUP BY ra.location_id, ra.resources_allocated;
```

**Results (CSV format):**
```csv
location_id,casualties_per_resource
1,1.5
2,1.2
3,1.1
```

**Query 8: This data can help identify locations that are under-resourced but have high casualties, indicating a need for reallocation.**

```sql
SELECT ra.location_id, ra.resources_allocated, (c.killed + c.injured) AS total_casualties FROM ResourceAllocation ra JOIN Casualties c ON ra.location_id = c.location_id WHERE ra.resources_allocated < [low_resource_threshold] AND (c.killed + c.injured) > [high_casualty_threshold];  -- Replace thresholds with actual values;
```

**Error:** Execution failed on sql 'SELECT ra.location_id, ra.resources_allocated, (c.killed + c.injured) AS total_casualties FROM ResourceAllocation ra JOIN Casualties c ON ra.location_id = c.location_id WHERE ra.resources_allocated < [low_resource_threshold] AND (c.killed + c.injured) > [high_casualty_threshold];  -- Replace thresholds with actual values;': no such column: low_resource_threshold

