# Complete Optimization Problem and Solution: phone_market

## 1. Problem Context and Goals

### Context  
A phone distributor is tasked with optimizing the allocation of phone stocks across various markets to maximize total revenue. The distributor must decide how many units of each phone model to allocate to each market, ensuring that the total stock allocated does not exceed the available stock for each phone model, the total stock in each market does not exceed its capacity, and the minimum stock requirements for each phone model in each market are met.  

The decision variables are the number of units of each phone model allocated to each market, represented as integers. The operational parameters include the price of each phone model, which serves as the coefficient in the objective function, and the maximum stock capacity for each market, which acts as a constraint bound for the total stock in each market. Additionally, the minimum stock requirements for each phone model in each market are used as constraint bounds to ensure adequate stock presence.  

The business configuration includes scalar parameters such as the maximum market capacity, which is set to 2000 units across all markets, and the minimum stock requirement, which is set to 50 units for each phone model in each market. These parameters ensure scalability and meet demand requirements.  

### Goals  
The primary goal of this optimization problem is to maximize the total revenue generated from the allocation of phone stocks across markets. This is achieved by determining the optimal number of units of each phone model to allocate to each market, considering the price of each phone model as the revenue driver. Success is measured by the total revenue calculated as the sum of the price of each phone model multiplied by the number of units allocated to each market.  

## 2. Constraints  

The optimization problem is subject to the following constraints:  
1. **Market Capacity Constraint**: The total number of units allocated to each market must not exceed the maximum stock capacity of that market. This ensures that the distributor does not overstock any market beyond its capacity.  
2. **Minimum Stock Requirement Constraint**: The number of units of each phone model allocated to each market must meet or exceed the minimum stock requirement for that phone model in that market. This ensures that each market has sufficient stock to meet demand.  

These constraints are designed to ensure that the allocation of phone stocks is both feasible and aligned with business requirements, without introducing any nonlinear relationships.  

## 3. Available Data  

### Database Schema  
```sql
-- Iteration 1 Database Schema
-- Objective: Schema changes include adding tables for maximum market capacities and minimum stock requirements, and updating business configuration logic to include scalar parameters and formulas for optimization constraints.

CREATE TABLE phone (
  Phone_ID INTEGER,
  Price FLOAT
);

CREATE TABLE market (
  Market_ID INTEGER,
  Num_of_shops INTEGER
);

CREATE TABLE phone_market (
  Market_ID INTEGER,
  Phone_ID INTEGER,
  Num_of_stock INTEGER
);

CREATE TABLE market_capacity (
  Market_ID INTEGER,
  Max_Capacity INTEGER
);

CREATE TABLE phone_min_stock (
  Market_ID INTEGER,
  Phone_ID INTEGER,
  Min_Stock INTEGER
);
```

### Data Dictionary  
- **phone**: Stores information about each phone model, including its unique identifier and price. The price is used as the coefficient in the objective function to calculate total revenue.  
- **market**: Stores information about each market, including its unique identifier and the number of shops. The maximum stock capacity for each market is derived from this table and used as a constraint bound.  
- **phone_market**: Stores the allocation of phone stocks across markets, including the number of units of each phone model allocated to each market. This table represents the decision variables in the optimization problem.  
- **market_capacity**: Stores the maximum stock capacity for each market, which is used as a constraint bound to ensure that the total stock allocated does not exceed the market's capacity.  
- **phone_min_stock**: Stores the minimum stock requirements for each phone model in each market, which is used as a constraint bound to ensure that each market has sufficient stock to meet demand.  


### Retrieved Values

**Query 1: This is crucial for determining the revenue generated by each unit of phone allocated to a market.**

```sql
SELECT Phone_ID, Price FROM phone;
```

**Results (CSV format):**
```csv
Phone_ID,Price
1,699.99
2,899.99
3,999.99
```

**Query 2: This ensures that the total stock allocated does not exceed the market's capacity.**

```sql
SELECT Market_ID, Max_Capacity FROM market_capacity;
```

**Results (CSV format):**
```csv
Market_ID,Max_Capacity
1,1000
2,1500
3,2000
```

**Query 3: This ensures that each market has sufficient stock to meet demand.**

```sql
SELECT Market_ID, Phone_ID, Min_Stock FROM phone_min_stock;
```

**Results (CSV format):**
```csv
Market_ID,Phone_ID,Min_Stock
1,1,50
2,2,100
3,3,150
```

**Query 4: This data is essential for understanding the current state and making adjustments to optimize revenue.**

```sql
SELECT Market_ID, Phone_ID, Num_of_stock FROM phone_market;
```

**Results (CSV format):**
```csv
Market_ID,Phone_ID,Num_of_stock
1,1,50
2,2,100
3,3,150
```

**Query 5: This can provide additional context for the optimization problem.**

```sql
SELECT Market_ID, Num_of_shops FROM market;
```

**Results (CSV format):**
```csv
Market_ID,Num_of_shops
1,10
2,15
3,20
```

**Query 6: This aggregated data is useful for checking the feasibility of the current allocation.**

```sql
SELECT Market_ID, SUM(Num_of_stock) AS Total_Stock FROM phone_market GROUP BY Market_ID;
```

**Results (CSV format):**
```csv
Market_ID,Total_Stock
1,50
2,100
3,150
```

**Query 7: This aggregated data is useful for checking the feasibility of the current allocation.**

```sql
SELECT Phone_ID, SUM(Num_of_stock) AS Total_Stock FROM phone_market GROUP BY Phone_ID;
```

**Results (CSV format):**
```csv
Phone_ID,Total_Stock
1,50
2,100
3,150
```

**Query 8: This data is useful for understanding the trade-offs between revenue and minimum stock requirements.**

```sql
SELECT p.Phone_ID, p.Price, pm.Market_ID, pm.Min_Stock FROM phone p JOIN phone_min_stock pm ON p.Phone_ID = pm.Phone_ID;
```

**Results (CSV format):**
```csv
Phone_ID,Price,Market_ID,Min_Stock
1,699.99,1,50
2,899.99,2,100
3,999.99,3,150
```

**Query 9: This data is useful for checking the feasibility of the current allocation.**

```sql
SELECT mc.Market_ID, mc.Max_Capacity, SUM(pm.Num_of_stock) AS Total_Stock FROM market_capacity mc JOIN phone_market pm ON mc.Market_ID = pm.Market_ID GROUP BY mc.Market_ID, mc.Max_Capacity;
```

**Results (CSV format):**
```csv
Market_ID,Max_Capacity,Total_Stock
1,1000,50
2,1500,100
3,2000,150
```

**Query 10: This data is useful for checking the feasibility of the current allocation.**

```sql
SELECT pm.Market_ID, pm.Phone_ID, pm.Num_of_stock, pms.Min_Stock FROM phone_market pm JOIN phone_min_stock pms ON pm.Market_ID = pms.Market_ID AND pm.Phone_ID = pms.Phone_ID;
```

**Results (CSV format):**
```csv
Market_ID,Phone_ID,Num_of_stock,Min_Stock
1,1,50,50
2,2,100,100
3,3,150,150
```

