# Complete Optimization Problem and Solution: school_player

## 1. Problem Context and Goals

### Context  
The optimization problem focuses on allocating players to schools in a way that maximizes the overall performance of school sports teams. Each school has specific enrollment limits, and each team must adhere to position constraints to ensure balanced and effective team compositions. The decision to assign a player to a school is binary, meaning a player is either assigned to a school or not.  

The performance weight for each school and position is calculated based on the school's historical performance and the importance of the position. This weight is used to evaluate the contribution of assigning a player to a school. The business configuration includes:  
- A minimum team size of 11 players, ensuring that each school has enough players to form a complete team.  
- Minimum and maximum player requirements for each position, ensuring that teams have adequate coverage and flexibility. For example, a team must have at least 2 players and no more than 5 players in the "Forward" position.  

The performance weight is derived by multiplying the school's historical performance score by the position weight, ensuring that the objective function reflects both the school's capabilities and the strategic importance of each position.  

### Goals  
The primary goal of this optimization is to maximize the overall performance of all school teams. This is achieved by assigning players to schools in a way that aligns with the schools' historical performance and the players' positions. Success is measured by the total performance weight across all assignments, ensuring that the best possible team compositions are achieved while adhering to enrollment limits and position constraints.  

## 2. Constraints  

The optimization problem must adhere to the following constraints:  
1. **School Enrollment Limits**: The total number of players assigned to a school cannot exceed the school's enrollment capacity. For example, if a school can enroll up to 25 players, the sum of all player assignments to that school must be less than or equal to 25.  
2. **Position Constraints**: Each school must have a minimum and maximum number of players in each position. For instance, a school must have at least 2 players and no more than 5 players in the "Forward" position.  
3. **Minimum Team Size**: Each school must have at least 11 players assigned to form a complete team.  

These constraints ensure that the team compositions are feasible, balanced, and aligned with operational requirements.  

## 3. Available Data  

### Database Schema  
```sql
-- Iteration 1 Database Schema
-- Objective: Schema changes include creating tables for performance weights, position constraints, and team size requirements. Configuration logic updates include scalar parameters for minimum team size and position constraints, and formulas for performance weight calculations.

CREATE TABLE performance_weight (
  school_id INTEGER,
  position STRING,
  weight FLOAT
);

CREATE TABLE position_constraints (
  position STRING,
  min_players INTEGER,
  max_players INTEGER
);

CREATE TABLE school (
  school_id INTEGER,
  enrollment INTEGER,
  historical_performance FLOAT
);

CREATE TABLE player_assignment (
  player_id INTEGER,
  school_id INTEGER,
  assigned BOOLEAN
);
```

### Data Dictionary  
- **performance_weight**: Stores the performance weights for schools based on positions.  
  - `school_id`: Unique identifier for the school.  
  - `position`: Player position (e.g., Forward, Midfielder, Defender).  
  - `weight`: Performance weight for the school in the specified position, used in the objective function.  
- **position_constraints**: Stores the minimum and maximum number of players allowed in each position.  
  - `position`: Player position.  
  - `min_players`: Minimum number of players required in the position, used in position constraints.  
  - `max_players`: Maximum number of players allowed in the position, used in position constraints.  
- **school**: Stores school information, including enrollment capacity and historical performance.  
  - `school_id`: Unique identifier for the school.  
  - `enrollment`: Maximum number of players a school can enroll, used in enrollment constraints.  
  - `historical_performance`: Historical performance score of the school, used in performance weight calculation.  
- **player_assignment**: Stores the assignment of players to schools.  
  - `player_id`: Unique identifier for the player.  
  - `school_id`: Unique identifier for the school.  
  - `assigned`: Indicates if the player is assigned to the school, used as the decision variable.  


### Retrieved Values

**Query 1: This data helps in maximizing the overall performance of school teams by assigning players to schools based on their positions.**

```sql
SELECT pw.school_id, pw.position, pw.weight FROM performance_weight pw;
```

**Results (CSV format):**
```csv
school_id,position,weight
1,Forward,0.9
1,Midfielder,0.8
1,Defender,0.7
2,Forward,0.8
2,Midfielder,0.9
2,Defender,0.8
3,Forward,0.7
3,Midfielder,0.8
3,Defender,0.9
```

**Query 2: This data is used to enforce the position constraints in the optimization problem.**

```sql
SELECT pc.position, pc.min_players, pc.max_players FROM position_constraints pc;
```

**Results (CSV format):**
```csv
position,min_players,max_players
Forward,2,4
Midfielder,3,5
Defender,3,5
```

**Query 3: This data helps in ensuring that the total number of players assigned to a school does not exceed its enrollment capacity.**

```sql
SELECT s.school_id, s.enrollment, s.historical_performance FROM school s;
```

**Results (CSV format):**
```csv
school_id,enrollment,historical_performance
1,25,0.9
2,20,0.8
3,30,0.7
```

**Query 4: This data is used to determine which players are assigned to which schools and to ensure that the assignments meet the constraints.**

```sql
SELECT pa.player_id, pa.school_id, pa.assigned FROM player_assignment pa;
```

**Results (CSV format):**
```csv
player_id,school_id,assigned
1,1,0
2,2,1
3,3,0
4,1,1
5,2,0
6,3,1
7,1,0
8,2,1
9,3,0
10,1,1
```

**Query 5: This aggregated data helps in ensuring that each school has at least 11 players and does not exceed its enrollment capacity.**

```sql
SELECT pa.school_id, COUNT(pa.player_id) AS total_players FROM player_assignment pa WHERE pa.assigned = TRUE GROUP BY pa.school_id;
```

**Results (CSV format):**
```csv
school_id,total_players
1,2
2,2
3,1
```

**Query 6: This aggregated data helps in ensuring that each school has the required number of players in each position.**

```sql
SELECT pa.school_id, pw.position, COUNT(pa.player_id) AS players_in_position FROM player_assignment pa JOIN performance_weight pw ON pa.school_id = pw.school_id WHERE pa.assigned = TRUE GROUP BY pa.school_id, pw.position;
```

**Results (CSV format):**
```csv
school_id,position,players_in_position
1,Defender,2
1,Forward,2
1,Midfielder,2
2,Defender,2
2,Forward,2
2,Midfielder,2
3,Defender,1
3,Forward,1
3,Midfielder,1
```

**Query 7: This data helps in evaluating the contribution of each player assignment to the overall performance of the school teams.**

```sql
SELECT pa.player_id, pa.school_id, pw.position, pw.weight FROM player_assignment pa JOIN performance_weight pw ON pa.school_id = pw.school_id WHERE pa.assigned = TRUE;
```

**Results (CSV format):**
```csv
player_id,school_id,position,weight
2,2,Defender,0.8
2,2,Forward,0.8
2,2,Midfielder,0.9
4,1,Defender,0.7
4,1,Forward,0.9
4,1,Midfielder,0.8
6,3,Defender,0.9
6,3,Forward,0.7
6,3,Midfielder,0.8
8,2,Defender,0.8
8,2,Forward,0.8
8,2,Midfielder,0.9
10,1,Defender,0.7
10,1,Forward,0.9
10,1,Midfielder,0.8
```

**Query 8: This data helps in prioritizing assignments to schools with higher historical performance.**

```sql
SELECT s.school_id, s.historical_performance, s.enrollment FROM school s;
```

**Results (CSV format):**
```csv
school_id,historical_performance,enrollment
1,0.9,25
2,0.8,20
3,0.7,30
```

**Query 9: This data is used to enforce the position constraints in the optimization problem.**

```sql
SELECT pc.position, pc.min_players, pc.max_players FROM position_constraints pc;
```

**Results (CSV format):**
```csv
position,min_players,max_players
Forward,2,4
Midfielder,3,5
Defender,3,5
```

**Query 10: This aggregated data helps in identifying any potential imbalances in player assignments.**

```sql
SELECT pw.position, COUNT(pa.player_id) AS total_players_in_position FROM player_assignment pa JOIN performance_weight pw ON pa.school_id = pw.school_id WHERE pa.assigned = TRUE GROUP BY pw.position;
```

**Results (CSV format):**
```csv
position,total_players_in_position
Defender,5
Forward,5
Midfielder,5
```

