# Complete Optimization Problem and Solution: sports_competition

## 1. Problem Context and Goals

### Context  
The sports league is focused on optimizing the allocation of players to clubs to maximize the total points scored across all clubs. This decision-making process involves assigning players to clubs in a way that respects the operational constraints of each club, including the maximum and minimum number of players allowed and the total budget available for player salaries. The league uses a binary decision variable to determine whether a player is assigned to a specific club, ensuring that each assignment is clear and definitive. The points scored by each player in a club are used as the primary metric to evaluate the success of the allocation. The league’s operational parameters are designed to align with a linear optimization approach, avoiding complex scenarios that would require nonlinear relationships, such as variable products or divisions. The business configuration includes scalar parameters like the points scored by players in clubs and the binary decision variable for player assignments, ensuring that the optimization problem remains straightforward and mathematically consistent.

### Goals  
The primary goal of the optimization is to maximize the total points scored by all clubs through the optimal assignment of players. This is achieved by considering the points each player is expected to contribute to a club and ensuring that the assignments respect the operational constraints of each club. Success is measured by the total points accumulated across all clubs, which directly reflects the effectiveness of the player allocation strategy. The optimization process focuses on linear relationships, ensuring that the objective and constraints are straightforward and aligned with the league’s operational requirements.

## 2. Constraints  

The optimization problem is subject to several key constraints that ensure the feasibility and fairness of the player allocations:  
1. **Maximum Players per Club**: Each club has a limit on the number of players it can accommodate. The total number of players assigned to a club must not exceed this limit.  
2. **Minimum Players per Club**: Each club must have a minimum number of players to ensure competitive viability. The total number of players assigned to a club must meet or exceed this requirement.  
3. **Budget Limit**: Each club has a total budget available for player salaries. The combined salaries of all players assigned to a club must not exceed this budget.  

These constraints are designed to align with the league’s operational requirements and ensure that the optimization problem remains linear and mathematically consistent.

## 3. Available Data  

### Database Schema  
```sql
-- Iteration 2 Database Schema
-- Objective: Schema changes include creating new tables for missing optimization requirements (player_points and player_club_assignments) and updating business configuration logic with scalar parameters and formulas.

CREATE TABLE club_constraints (
  club_id INTEGER,
  max_players INTEGER,
  min_players INTEGER,
  budget FLOAT
);

CREATE TABLE player_salaries (
  player_id INTEGER,
  salary FLOAT
);

CREATE TABLE player_points (
  player_id INTEGER,
  club_id INTEGER,
  points INTEGER
);

CREATE TABLE player_club_assignments (
  player_id INTEGER,
  club_id INTEGER,
  assignment INTEGER
);
```

### Data Dictionary  
- **club_constraints**: This table defines the operational constraints for each club, including the maximum and minimum number of players allowed and the total budget available for player salaries. These constraints are used to ensure that the player allocations are feasible and fair.  
  - **club_id**: Unique identifier for the club.  
  - **max_players**: Maximum number of players allowed per club.  
  - **min_players**: Minimum number of players required per club.  
  - **budget**: Total budget available for player salaries per club.  

- **player_salaries**: This table contains the salary information for each player, which is used to ensure that the total salaries of players assigned to a club do not exceed the club’s budget.  
  - **player_id**: Unique identifier for the player.  
  - **salary**: Salary of the player.  

- **player_points**: This table records the points scored by each player in a club, which are used as the primary metric for evaluating the success of the player allocations.  
  - **player_id**: Unique identifier for the player.  
  - **club_id**: Unique identifier for the club.  
  - **points**: Points scored by the player in the club.  

- **player_club_assignments**: This table represents the binary decision variable indicating whether a player is assigned to a club.  
  - **player_id**: Unique identifier for the player.  
  - **club_id**: Unique identifier for the club.  
  - **assignment**: Binary decision variable indicating whether the player is assigned to the club.  


### Retrieved Values

**Query 1: This is crucial for the objective function, which aims to maximize the total points scored across all clubs.**

```sql
SELECT player_id, club_id, points FROM player_points;
```

**Results (CSV format):**
```csv
player_id,club_id,points
1,1,15
2,2,20
3,3,10
```

**Query 2: This data is essential for the budget constraint, ensuring that the total salaries of players assigned to a club do not exceed the club's budget.**

```sql
SELECT player_id, salary FROM player_salaries;
```

**Results (CSV format):**
```csv
player_id,salary
1,75000.0
2,100000.0
3,50000.0
```

**Query 3: These constraints are necessary to ensure that the player allocations are feasible and fair.**

```sql
SELECT club_id, max_players, min_players, budget FROM club_constraints;
```

**Results (CSV format):**
```csv
club_id,max_players,min_players,budget
1,25,18,1500000.0
2,30,20,2000000.0
3,22,15,1000000.0
```

**Query 4: This data is important for understanding the initial state of player allocations and for verifying constraints during optimization.**

```sql
SELECT player_id, club_id, assignment FROM player_club_assignments;
```

**Results (CSV format):**
```csv
player_id,club_id,assignment
1,1,1
2,2,1
3,3,1
```

**Query 5: This aggregated data can help identify high-value players who contribute significantly to the objective function.**

```sql
SELECT player_id, SUM(points) AS total_points FROM player_points GROUP BY player_id;
```

**Results (CSV format):**
```csv
player_id,total_points
1,15
2,20
3,10
```

**Query 6: This aggregated data is useful for verifying budget constraints and understanding the financial impact of player allocations.**

```sql
SELECT a.club_id, SUM(s.salary) AS total_salary FROM player_club_assignments a JOIN player_salaries s ON a.player_id = s.player_id GROUP BY a.club_id;
```

**Results (CSV format):**
```csv
club_id,total_salary
1,75000.0
2,100000.0
3,50000.0
```

**Query 7: This aggregated data is important for verifying the max_players and min_players constraints.**

```sql
SELECT club_id, COUNT(player_id) AS num_players FROM player_club_assignments GROUP BY club_id;
```

**Results (CSV format):**
```csv
club_id,num_players
1,1
2,1
3,1
```

**Query 8: This combined data is useful for evaluating the trade-offs between player contributions and costs.**

```sql
SELECT p.player_id, p.club_id, p.points, s.salary FROM player_points p JOIN player_salaries s ON p.player_id = s.player_id;
```

**Results (CSV format):**
```csv
player_id,club_id,points,salary
1,1,15,75000.0
2,2,20,100000.0
3,3,10,50000.0
```

**Query 9: This aggregated data helps in evaluating the overall performance and financial status of each club.**

```sql
SELECT a.club_id, SUM(p.points) AS total_points, SUM(s.salary) AS total_salary FROM player_club_assignments a JOIN player_points p ON a.player_id = p.player_id AND a.club_id = p.club_id JOIN player_salaries s ON a.player_id = s.player_id GROUP BY a.club_id;
```

**Results (CSV format):**
```csv
club_id,total_points,total_salary
1,15,75000.0
2,20,100000.0
3,10,50000.0
```

**Query 10: This data is useful for identifying available players who can be assigned to clubs to meet min_players constraints or to improve total points.**

```sql
SELECT player_id FROM player_salaries WHERE player_id NOT IN (SELECT player_id FROM player_club_assignments);
```

**Results (CSV format):**
```csv
player_id
```

