# Complete Optimization Problem and Solution: twitter_1

## 1. Problem Context and Goals

### Context  
The business aims to maximize the reach of tweets by strategically selecting a subset of users to post tweets. The reach is determined by the total number of followers of the selected users. Each user has a specific follower count, and the decision to select a user for tweeting is binary—either they are selected or not. The selection process must adhere to two key operational constraints:  
1. **Total Tweet Limit**: The total number of tweets across all selected users cannot exceed a predefined maximum limit. This ensures that the system is not overwhelmed with tweets.  
2. **User Tweet Limit**: Each user has a maximum number of tweets they are allowed to post. This prevents any single user from being overburdened with tweeting responsibilities.  

The business configuration includes two critical scalar parameters:  
- **Maximum Total Tweets Allowed**: The system-wide limit on the total number of tweets that can be posted.  
- **Maximum Tweets Per User**: The individual limit on the number of tweets each user can post.  

These parameters are designed to balance user engagement with operational feasibility, ensuring a realistic and manageable tweet distribution strategy.

### Goals  
The primary goal of this optimization problem is to maximize the total reach of the tweets. This is achieved by selecting users whose combined follower count is as large as possible, while respecting the operational constraints. Success is measured by the total number of followers reached through the selected tweets. The optimization process ensures that the selection of users is both strategic and compliant with the predefined limits on tweet volume.

## 2. Constraints  

The optimization problem is subject to the following constraints:  
1. **Total Tweet Constraint**: The sum of tweets posted by all selected users must not exceed the maximum total number of tweets allowed. This ensures that the system operates within its capacity.  
2. **User Tweet Constraint**: Each selected user cannot post more tweets than their individual maximum limit. This prevents overloading any single user with tweeting responsibilities.  

These constraints are designed to maintain operational efficiency and user engagement, ensuring that the tweet distribution strategy is both effective and sustainable.

## 3. Available Data  

### Database Schema  
```sql
-- Iteration 1 Database Schema
-- Objective: Schema changes include creating new tables for decision variables and constraint bounds, and updating business configuration logic to include scalar parameters and formulas for optimization constraints.

CREATE TABLE user_profiles (
  user_id INTEGER,
  followers INTEGER,
  max_tweets_per_user INTEGER
);

CREATE TABLE tweet_selection (
  user_id INTEGER,
  is_selected BOOLEAN
);

CREATE TABLE user_tweet_limits (
  user_id INTEGER,
  max_tweets INTEGER
);
```

### Data Dictionary  
- **user_profiles**:  
  - **user_id**: Unique identifier for each user.  
  - **followers**: Number of followers of the user, used to determine the reach of their tweets.  
  - **max_tweets_per_user**: Maximum number of tweets allowed per user, used to constrain the number of tweets each user can post.  

- **tweet_selection**:  
  - **user_id**: Unique identifier for each user.  
  - **is_selected**: Binary indicator of whether the user is selected to tweet.  

- **user_tweet_limits**:  
  - **user_id**: Unique identifier for each user.  
  - **max_tweets**: Maximum number of tweets allowed per user, used to constrain the number of tweets each user can post.  


### Retrieved Values

**Query 1: This data is crucial for the objective function (maximizing reach) and the user tweet constraint.**

```sql
SELECT user_id, followers, max_tweets_per_user FROM user_profiles;
```

**Results (CSV format):**
```csv
user_id,followers,max_tweets_per_user
1,1500,3
2,2500,5
3,1000,2
```

**Query 2: This data is important for understanding which users are currently selected to tweet.**

```sql
SELECT user_id, is_selected FROM tweet_selection;
```

**Results (CSV format):**
```csv
user_id,is_selected
1,0
2,1
3,0
```

**Query 3: This data is essential for enforcing the user tweet constraint.**

```sql
SELECT user_id, max_tweets FROM user_tweet_limits;
```

**Results (CSV format):**
```csv
user_id,max_tweets
1,3
2,5
3,2
```

**Query 4: This aggregated data helps in understanding the potential maximum reach.**

```sql
SELECT SUM(followers) AS total_followers FROM user_profiles;
```

**Results (CSV format):**
```csv
total_followers
5000
```

**Query 5: This aggregated data is important for the total tweet constraint.**

```sql
SELECT SUM(max_tweets_per_user) AS total_tweets_allowed FROM user_profiles;
```

**Results (CSV format):**
```csv
total_tweets_allowed
10
```

**Query 6: This combined data is useful for evaluating the current state of the optimization problem.**

```sql
SELECT up.user_id, up.followers, up.max_tweets_per_user, ts.is_selected, utl.max_tweets FROM user_profiles up LEFT JOIN tweet_selection ts ON up.user_id = ts.user_id LEFT JOIN user_tweet_limits utl ON up.user_id = utl.user_id;
```

**Results (CSV format):**
```csv
user_id,followers,max_tweets_per_user,is_selected,max_tweets
1,1500,3,0,3
2,2500,5,1,5
3,1000,2,0,2
```

**Query 7: This data is crucial for ensuring the total tweet constraint is not exceeded.**

```sql
SELECT SUM(CASE WHEN is_selected THEN 1 ELSE 0 END) AS total_selected_tweets FROM tweet_selection;
```

**Results (CSV format):**
```csv
total_selected_tweets
1
```

**Query 8: This data helps in understanding the current reach and tweet distribution.**

```sql
SELECT up.user_id, up.followers, up.max_tweets_per_user, utl.max_tweets FROM user_profiles up JOIN tweet_selection ts ON up.user_id = ts.user_id JOIN user_tweet_limits utl ON up.user_id = utl.user_id WHERE ts.is_selected = TRUE;
```

**Results (CSV format):**
```csv
user_id,followers,max_tweets_per_user,max_tweets
2,2500,5,5
```

**Query 9: This data helps in identifying potential candidates to increase reach.**

```sql
SELECT up.user_id, up.followers, up.max_tweets_per_user, utl.max_tweets FROM user_profiles up LEFT JOIN tweet_selection ts ON up.user_id = ts.user_id LEFT JOIN user_tweet_limits utl ON up.user_id = utl.user_id WHERE ts.is_selected IS NULL OR ts.is_selected = FALSE;
```

**Results (CSV format):**
```csv
user_id,followers,max_tweets_per_user,max_tweets
1,1500,3,3
3,1000,2,2
```

**Query 10: This data is important for evaluating the current effectiveness of the selection strategy.**

```sql
SELECT SUM(up.followers) AS total_reach FROM user_profiles up JOIN tweet_selection ts ON up.user_id = ts.user_id WHERE ts.is_selected = TRUE;
```

**Results (CSV format):**
```csv
total_reach
2500
```

