# Complete DOCPLEX implementation - Retry Attempt 4

from docplex.mp.model import Model

def aircraft_assignment_optimization():
    # 1. MODEL & DATA SETUP
    mdl = Model(name="Aircraft_Assignment_Optimization")
    
    # Aircraft types and airports
    aircraft_types = ['Boeing 737', 'Airbus A320', 'Boeing 777']
    airports = ['JFK', 'LAX', 'ORD']
    
    # Operational costs (aircraft_type, airport_code)
    operational_costs = {
        ('Boeing 737', 'JFK'): 5000.0,
        ('Airbus A320', 'JFK'): 5500.0,
        ('Boeing 777', 'JFK'): 8000.0,
        ('Boeing 737', 'LAX'): 4800.0,
        ('Airbus A320', 'LAX'): 5200.0,
        # Add missing operational costs here
        ('Boeing 737', 'ORD'): 4900.0,
        ('Airbus A320', 'ORD'): 5300.0,
        ('Boeing 777', 'ORD'): 8100.0,
        ('Boeing 777', 'LAX'): 7900.0  # Added missing operational cost
    }
    
    # Passenger capacities
    passenger_capacities = {
        'Boeing 737': 150,
        'Airbus A320': 180,
        'Boeing 777': 300
    }
    
    # Airport demands and movements
    passenger_demands = {
        'JFK': 15000,
        'LAX': 20000,
        'ORD': 18000
    }
    
    aircraft_movements = {
        'JFK': 50,
        'LAX': 60,
        'ORD': 55
    }
    
    # 2. VARIABLES
    x = mdl.continuous_var_matrix(aircraft_types, airports, name="x", lb=0)
    
    # 3. OBJECTIVE FUNCTION
    total_cost = mdl.sum(operational_costs[(i, j)] * x[i, j] for i in aircraft_types for j in airports)
    mdl.minimize(total_cost)
    
    # 4. CONSTRAINTS
    # Passenger Demand Constraint
    for j in airports:
        mdl.add_constraint(mdl.sum(passenger_capacities[i] * x[i, j] for i in aircraft_types) >= passenger_demands[j], ctname=f"passenger_demand_{j}")
    
    # Aircraft Movement Constraint
    for j in airports:
        mdl.add_constraint(mdl.sum(x[i, j] for i in aircraft_types) <= aircraft_movements[j], ctname=f"aircraft_movement_{j}")
    
    # 5. SOLVING & RESULTS
    solution = mdl.solve()
    
    if solution:
        print(f"Optimal value: {solution.objective_value}")
        for i in aircraft_types:
            for j in airports:
                value = solution.get_value(x[i, j])
                if value > 1e-6:
                    print(f"x[{i}, {j}] = {value:.3f}")
    else:
        print("No solution found")
        print(f"Status: {mdl.solve_details.status}")
    
    return mdl

# Execute the optimization
aircraft_assignment_optimization()