# Complete Optimization Problem and Solution: architecture

## 1. Problem Context and Goals

### Context  
A construction company is tasked with optimizing the allocation of projects to architects to minimize the total length of bridges and mills built. The company must decide which bridges and mills to construct, represented by binary decision variables indicating whether a specific bridge or mill is built. Each bridge has a defined length in meters, and each mill has a defined length in feet, which directly contribute to the total length to be minimized.  

The company operates under specific business rules to ensure fair and manageable workloads for architects. Each architect must be assigned to at least one project, as defined by the minimum number of projects per architect, and no architect can be assigned more than three projects, as defined by the maximum number of projects per architect. These rules ensure a balanced distribution of work while preventing overburdening any single architect.  

The operational parameters, such as the lengths of bridges and mills, are sourced from the current database, which includes realistic data generated by experts in business, data, and optimization. The business configuration parameters, including the minimum and maximum number of projects per architect, are defined as scalar values and are critical for enforcing the constraints in the optimization problem.  

### Goals  
The primary goal of this optimization problem is to minimize the total length of bridges and mills built by architects. This is achieved by strategically selecting which bridges and mills to construct, ensuring that the sum of their lengths is as small as possible. Success is measured by the reduction in total length, which directly impacts resource efficiency and cost savings for the company.  

The optimization process ensures that all architects are assigned to at least one project and that no architect is assigned more than three projects. These constraints are critical for maintaining workload balance and operational feasibility.  

## 2. Constraints  

The optimization problem is subject to the following constraints:  
1. **Minimum Projects per Architect**: Each architect must be assigned to at least one project. This ensures that all architects are actively contributing to the construction efforts.  
2. **Maximum Projects per Architect**: No architect can be assigned more than three projects. This prevents overburdening any single architect and ensures manageable workloads.  

These constraints are enforced using the minimum and maximum number of projects per architect, which are defined as scalar parameters in the business configuration.  

## 3. Available Data  

### Database Schema  
```sql
-- Iteration 3 Database Schema
-- Objective: Schema changes include adding tables for decision variables and constraint bounds, updating the data dictionary, and refining business configuration logic to include scalar parameters for minimum and maximum projects per architect.

CREATE TABLE bridge_lengths (
  bridge_id INTEGER,
  length_meters INTEGER
);

CREATE TABLE mill_lengths (
  mill_id INTEGER,
  length_feet INTEGER
);

CREATE TABLE architect_project_assignments (
  architect_id INTEGER,
  bridge_assignment BOOLEAN,
  mill_assignment BOOLEAN
);

CREATE TABLE architect_constraints (
  architect_id INTEGER,
  min_projects INTEGER,
  max_projects INTEGER
);
```

### Data Dictionary  
- **bridge_lengths**: Stores the length of each bridge in meters, which is used to calculate the total length of bridges built.  
  - `bridge_id`: Unique identifier for each bridge.  
  - `length_meters`: Length of the bridge in meters, used as a coefficient in the optimization objective.  

- **mill_lengths**: Stores the length of each mill in feet, which is used to calculate the total length of mills built.  
  - `mill_id`: Unique identifier for each mill.  
  - `length_feet`: Length of the mill in feet, used as a coefficient in the optimization objective.  

- **architect_project_assignments**: Tracks the assignment of architects to projects, indicating whether a bridge or mill is built.  
  - `architect_id`: Unique identifier for each architect.  
  - `bridge_assignment`: Indicates whether the architect is assigned to build a bridge.  
  - `mill_assignment`: Indicates whether the architect is assigned to build a mill.  

- **architect_constraints**: Defines the minimum and maximum number of projects each architect can handle.  
  - `architect_id`: Unique identifier for each architect.  
  - `min_projects`: Minimum number of projects the architect must be assigned to.  
  - `max_projects`: Maximum number of projects the architect can be assigned to.  

### Current Stored Values  
```sql
-- Iteration 3 Realistic Data
-- Generated by triple expert (business + data + optimization)
-- Values were determined based on typical construction project lengths and architect workload capacities, ensuring realistic and meaningful data for optimization.

-- Realistic data for bridge_lengths
INSERT INTO bridge_lengths (bridge_id, length_meters) VALUES (1, 120);
INSERT INTO bridge_lengths (bridge_id, length_meters) VALUES (2, 250);
INSERT INTO bridge_lengths (bridge_id, length_meters) VALUES (3, 400);

-- Realistic data for mill_lengths
INSERT INTO mill_lengths (mill_id, length_feet) VALUES (1, 350);
INSERT INTO mill_lengths (mill_id, length_feet) VALUES (2, 450);
INSERT INTO mill_lengths (mill_id, length_feet) VALUES (3, 550);

-- Realistic data for architect_project_assignments
INSERT INTO architect_project_assignments (architect_id, bridge_assignment, mill_assignment) VALUES (1, True, False);
INSERT INTO architect_project_assignments (architect_id, bridge_assignment, mill_assignment) VALUES (2, False, True);
INSERT INTO architect_project_assignments (architect_id, bridge_assignment, mill_assignment) VALUES (3, True, True);

-- Realistic data for architect_constraints
INSERT INTO architect_constraints (architect_id, min_projects, max_projects) VALUES (1, 1, 3);
INSERT INTO architect_constraints (architect_id, min_projects, max_projects) VALUES (2, 1, 3);
INSERT INTO architect_constraints (architect_id, min_projects, max_projects) VALUES (3, 1, 3);
```