# Complete Optimization Problem and Solution: candidate_poll

## 1. Problem Context and Goals

### Context  
A political campaign is focused on maximizing the overall support rate for a candidate by strategically allocating resources to different poll sources. Each poll source has a unique effectiveness in converting unsure voters to supporters, which is influenced by the amount of money invested in that source. The campaign must decide how much to invest in each poll source to achieve the highest possible support rate, while adhering to the following operational parameters:  

- **Total Budget**: The campaign has a fixed budget of $100,000 available for investment across all poll sources. This ensures that the total investment does not exceed the available funds.  
- **Minimum Investment**: Each poll source must receive at least $1,000 in investment to ensure meaningful engagement and impact on support rates.  
- **Maximum Support Rate**: For each poll source, there is a maximum achievable support rate of 80%, reflecting practical limitations in voter conversion.  

The campaign’s decision-making process is guided by two key metrics for each poll source:  
- **Initial Support Rate**: The current level of support for the candidate in each poll source before any additional investment.  
- **Conversion Rate**: The rate at which unsure voters convert to supporters per unit of investment in each poll source.  

By leveraging these metrics, the campaign aims to allocate investments in a way that maximizes the overall support rate while staying within budget and meeting minimum investment requirements.  

### Goals  
The primary goal of this optimization problem is to maximize the total support rate for the candidate across all poll sources. This is achieved by strategically determining the amount of money to invest in each poll source, considering the initial support rate and the conversion rate of unsure voters to supporters. Success is measured by the ability to increase the overall support rate while adhering to the campaign’s budget and investment constraints.  

## 2. Constraints  

The campaign’s investment strategy is subject to the following constraints:  

1. **Budget Constraint**: The total amount of money invested across all poll sources must not exceed the campaign’s total budget of $100,000.  
2. **Minimum Investment Constraint**: Each poll source must receive at least $1,000 in investment to ensure meaningful engagement.  
3. **Maximum Support Rate Constraint**: For each poll source, the combined effect of the initial support rate and the additional support gained from investment must not exceed the maximum achievable support rate of 80%.  

These constraints ensure that the campaign’s investment strategy is both financially feasible and operationally effective.  

## 3. Available Data  

### Database Schema  
```sql
-- Iteration 1 Database Schema
-- Objective: Schema changes include creating new tables for missing optimization parameters and updating business configuration logic to handle scalar parameters and formulas.

CREATE TABLE poll_source_conversion_rates (
  Poll_Source_ID INTEGER,
  Conversion_rate FLOAT
);

CREATE TABLE candidate (
  Poll_Source_ID INTEGER,
  Support_rate FLOAT
);

CREATE TABLE poll_source_investments (
  Poll_Source_ID INTEGER,
  Investment FLOAT
);
```

### Data Dictionary  
The following tables and columns are used in this optimization problem:  

- **poll_source_conversion_rates**:  
  - **Poll_Source_ID**: Unique identifier for each poll source.  
  - **Conversion_rate**: The rate at which unsure voters convert to supporters per unit of investment in the poll source. This is a key coefficient in the optimization objective.  

- **candidate**:  
  - **Poll_Source_ID**: Unique identifier for each poll source.  
  - **Support_rate**: The initial support rate for the candidate in the poll source before any additional investment. This is a key coefficient in the optimization objective.  

- **poll_source_investments**:  
  - **Poll_Source_ID**: Unique identifier for each poll source.  
  - **Investment**: The amount of money invested in the poll source. This is the decision variable in the optimization model.  

### Current Stored Values  
```sql
-- Iteration 1 Realistic Data
-- Generated by triple expert (business + data + optimization)
-- Values were determined based on realistic campaign budgets, typical conversion rates for political polls, and initial support rates that reflect a competitive race. Investments were set to ensure they are within the budget and meet minimum investment requirements.

-- Realistic data for poll_source_conversion_rates
INSERT INTO poll_source_conversion_rates (Poll_Source_ID, Conversion_rate) VALUES (1, 0.05);
INSERT INTO poll_source_conversion_rates (Poll_Source_ID, Conversion_rate) VALUES (2, 0.07);
INSERT INTO poll_source_conversion_rates (Poll_Source_ID, Conversion_rate) VALUES (3, 0.1);

-- Realistic data for candidate
INSERT INTO candidate (Poll_Source_ID, Support_rate) VALUES (1, 0.3);
INSERT INTO candidate (Poll_Source_ID, Support_rate) VALUES (2, 0.4);
INSERT INTO candidate (Poll_Source_ID, Support_rate) VALUES (3, 0.5);

-- Realistic data for poll_source_investments
INSERT INTO poll_source_investments (Poll_Source_ID, Investment) VALUES (1, 1000);
INSERT INTO poll_source_investments (Poll_Source_ID, Investment) VALUES (2, 2000);
INSERT INTO poll_source_investments (Poll_Source_ID, Investment) VALUES (3, 3000);
```