# Complete DOCPLEX implementation - Retry Attempt 4

from docplex.mp.model import Model

def optimize_investment():
    # 1. MODEL & DATA SETUP
    mdl = Model(name="culture_company_investment")
    
    # Data from the problem statement
    budget = 1000000
    min_book_club = 100000
    min_movie = 150000
    max_book_club = 500000
    max_movie = 600000
    min_total_profit = 200000
    profit_book_club = 0.15
    profit_movie = 0.20
    
    # 2. VARIABLES
    x_b = mdl.continuous_var(name="x_book_club", lb=min_book_club, ub=max_book_club)
    x_m = mdl.continuous_var(name="x_movie", lb=min_movie, ub=max_movie)
    
    # 3. OBJECTIVE FUNCTION
    total_profit = profit_book_club * x_b + profit_movie * x_m
    mdl.maximize(total_profit)
    
    # 4. CONSTRAINTS
    # Budget Constraint
    mdl.add_constraint(x_b + x_m <= budget, ctname="budget_constraint")
    
    # Minimum Total Profit Constraint
    mdl.add_constraint(profit_book_club * x_b + profit_movie * x_m >= min_total_profit, ctname="min_total_profit_constraint")
    
    # 5. SOLVING & RESULTS
    solution = mdl.solve()
    
    if solution:
        print(f"Optimal value: {solution.objective_value}")
        print(f"Investment in Book Clubs: {solution.get_value(x_b)}")
        print(f"Investment in Movies: {solution.get_value(x_m)}")
    else:
        print("No solution found")
        print(f"Status: {mdl.solve_details.status}")
        if mdl.solve_details.status == "infeasible":
            print("The problem is infeasible. Please check the constraints.")
        elif mdl.solve_details.status == "unbounded":
            print("The problem is unbounded. Please check the objective function and constraints.")
    
    return mdl

# Execute the optimization
optimize_investment()