# Complete Optimization Problem and Solution: customer_complaints

## 1. Problem Context and Goals

### Context  
The company operates in a customer service environment where handling complaints efficiently is critical to maintaining customer satisfaction and operational cost-effectiveness. The primary business decision revolves around assigning staff members to customer complaints in a way that minimizes the total cost of handling these complaints. The cost is directly influenced by the time each staff member spends on each complaint and their respective hourly wages. 

Each complaint has specific time requirements, defined by a minimum and maximum time needed for resolution. Staff members also have individual maximum working hours, ensuring that no one is overburdened. The goal is to allocate time spent by staff on complaints in a manner that respects these constraints while minimizing the total cost. This problem naturally lends itself to a linear optimization formulation, as the relationships between time spent, wages, and constraints are all proportional and additive.

### Goals  
The optimization goal is to minimize the total cost of handling customer complaints. This cost is calculated as the sum of the time each staff member spends on each complaint multiplied by their hourly wage. Success is measured by achieving the lowest possible total cost while ensuring that all complaints are fully addressed within the specified time bounds and that no staff member exceeds their maximum working hours. The objective is linear, as it involves summing products of time and wage, both of which are fixed parameters in this context.

## 2. Constraints  

The optimization problem must adhere to the following constraints:  
1. **Complaint Assignment Constraint**: Each complaint must be fully assigned to one or more staff members, ensuring that the total time spent on each complaint sums to exactly one unit of time. This ensures that all complaints are fully addressed.  
2. **Time Bounds Constraint**: The time spent by any staff member on a specific complaint must fall within the predefined minimum and maximum time limits for that complaint. This ensures that complaints are neither rushed nor unnecessarily prolonged.  
3. **Staff Working Hours Constraint**: The total time spent by each staff member across all complaints must not exceed their maximum working hours. This ensures that no staff member is overworked.  

These constraints are linear, as they involve summing time spent and comparing it to fixed bounds, without any multiplicative or divisive relationships between variables.

## 3. Available Data  

### Database Schema  
```sql
-- Iteration 2 Database Schema
-- Objective: Schema changes include creating a new table for the missing decision variable 'time_spent[staff_id, complaint_id]'. Configuration logic remains unchanged as no additional scalar parameters or formulas were identified.

CREATE TABLE staff_wages (
  staff_id INTEGER,
  hourly_wage FLOAT
);

CREATE TABLE complaint_time_constraints (
  complaint_id INTEGER,
  min_time FLOAT,
  max_time FLOAT
);

CREATE TABLE staff_working_hours (
  staff_id INTEGER,
  max_hours FLOAT
);

CREATE TABLE time_spent (
  staff_id INTEGER,
  complaint_id INTEGER,
  time_spent FLOAT
);
```

### Data Dictionary  
- **staff_wages**:  
  - **Purpose**: Stores the hourly wage of each staff member.  
  - **Optimization Role**: Provides the coefficients for the objective function, representing the cost per hour for each staff member.  
  - **Columns**:  
    - `staff_id`: Unique identifier for each staff member.  
    - `hourly_wage`: Hourly wage of the staff member, used to calculate the total cost.  

- **complaint_time_constraints**:  
  - **Purpose**: Defines the minimum and maximum time required to handle each complaint.  
  - **Optimization Role**: Provides the bounds for the time spent on each complaint, ensuring resolutions are neither rushed nor prolonged.  
  - **Columns**:  
    - `complaint_id`: Unique identifier for each complaint.  
    - `min_time`: Minimum time required to handle the complaint.  
    - `max_time`: Maximum time allowed to handle the complaint.  

- **staff_working_hours**:  
  - **Purpose**: Specifies the maximum working hours for each staff member.  
  - **Optimization Role**: Provides the upper bound for the total time each staff member can spend on all complaints.  
  - **Columns**:  
    - `staff_id`: Unique identifier for each staff member.  
    - `max_hours`: Maximum working hours for the staff member.  

- **time_spent**:  
  - **Purpose**: Tracks the time spent by each staff member on each complaint.  
  - **Optimization Role**: Represents the decision variable in the optimization model, determining how time is allocated.  
  - **Columns**:  
    - `staff_id`: Unique identifier for each staff member.  
    - `complaint_id`: Unique identifier for each complaint.  
    - `time_spent`: Time spent by the staff member on the complaint.  

### Current Stored Values  
```sql
-- Iteration 2 Realistic Data
-- Generated by triple expert (business + data + optimization)
-- Values were determined based on industry standards, realistic business scenarios, and ensuring the optimization problem remains solvable. Hourly wages were set to reflect typical salaries for customer service roles. Time constraints for complaints were based on average handling times, and maximum working hours were set to standard full-time workweeks. Time spent values were generated to fall within the min and max time constraints for each complaint.

-- Realistic data for staff_wages
INSERT INTO staff_wages (staff_id, hourly_wage) VALUES (1, 25.0);
INSERT INTO staff_wages (staff_id, hourly_wage) VALUES (2, 30.0);
INSERT INTO staff_wages (staff_id, hourly_wage) VALUES (3, 35.0);

-- Realistic data for complaint_time_constraints
INSERT INTO complaint_time_constraints (complaint_id, min_time, max_time) VALUES (1, 1.0, 3.0);
INSERT INTO complaint_time_constraints (complaint_id, min_time, max_time) VALUES (2, 1.5, 4.0);
INSERT INTO complaint_time_constraints (complaint_id, min_time, max_time) VALUES (3, 2.0, 5.0);

-- Realistic data for staff_working_hours
INSERT INTO staff_working_hours (staff_id, max_hours) VALUES (1, 40.0);
INSERT INTO staff_working_hours (staff_id, max_hours) VALUES (2, 45.0);
INSERT INTO staff_working_hours (staff_id, max_hours) VALUES (3, 50.0);

-- Realistic data for time_spent
INSERT INTO time_spent (staff_id, complaint_id, time_spent) VALUES (1, 1, 1.5);
INSERT INTO time_spent (staff_id, complaint_id, time_spent) VALUES (2, 2, 2.0);
INSERT INTO time_spent (staff_id, complaint_id, time_spent) VALUES (3, 3, 2.5);
```