# Complete Optimization Problem and Solution: election

## 1. Problem Context and Goals

### Context  
In the context of an upcoming election, the campaign team aims to optimize the allocation of resources across various counties to maximize voter turnout. The resources include advertising, events, and other campaign activities. The decision involves determining how much to allocate to each county, represented as a continuous variable. The goal is to distribute the campaign budget in a way that maximizes the expected voter turnout, considering the historical effectiveness of spending in each county.

The campaign has a total budget of $1,000,000, which serves as the upper limit for the sum of all resource allocations across counties. Each county must receive a minimum of $10,000 to ensure a baseline campaign presence, and no county can receive more than $100,000 to prevent over-allocation. Additionally, the allocation must be proportional to the population of each county, with a proportionality factor of 0.01, ensuring fairness in resource distribution.

The expected voter turnout per dollar spent in each county is a key metric, derived from historical data. This metric is used to calculate the overall effectiveness of the resource allocation, ensuring that the campaign maximizes its impact within the given budget and constraints.

### Goals  
The primary goal of this optimization problem is to maximize the total expected voter turnout across all counties. This is achieved by allocating campaign resources in a way that leverages the historical effectiveness of spending in each county. The success of the optimization is measured by the sum of the expected voter turnout per dollar spent multiplied by the amount allocated to each county. The objective is to ensure that the campaign resources are used as efficiently as possible to drive the highest possible voter turnout.

## 2. Constraints    

The optimization problem is subject to several constraints that ensure the resource allocation is both feasible and fair:

1. **Total Budget Constraint**: The sum of all resource allocations across counties must not exceed the total campaign budget of $1,000,000. This ensures that the campaign does not overspend.

2. **Minimum Allocation Constraint**: Each county must receive at least $10,000 in resources. This ensures that every county has a minimum level of campaign presence.

3. **Maximum Allocation Constraint**: No county can receive more than $100,000 in resources. This prevents over-allocation to any single county, ensuring a fair distribution of resources.

4. **Population Proportionality Constraint**: The resource allocation for each county must be at least 1% of its population. This ensures that the allocation is proportional to the population, promoting fairness in resource distribution.

These constraints are designed to ensure that the resource allocation is both practical and equitable, aligning with the campaign's strategic goals.

## 3. Available Data  

### Database Schema  
```sql
-- Iteration 1 Database Schema
-- Objective: Schema changes include creating tables for expected turnout per dollar and resource allocation limits. Configuration logic updates include scalar parameters for total budget, minimum and maximum allocations, and proportionality factor.

CREATE TABLE expected_turnout_per_dollar (
  County_Id INTEGER,
  turnout_per_dollar FLOAT
);

CREATE TABLE resource_allocation_limits (
  County_Id INTEGER,
  allocation INTEGER
);
```

### Data Dictionary  
- **expected_turnout_per_dollar**: This table contains the expected voter turnout per dollar spent in each county. The `County_Id` column uniquely identifies each county, while the `turnout_per_dollar` column represents the expected effectiveness of campaign spending in that county. This data is crucial for calculating the overall impact of resource allocation.

- **resource_allocation_limits**: This table defines the minimum and maximum resource allocation limits for each county. The `County_Id` column uniquely identifies each county, and the `allocation` column specifies the amount of resources allocated to that county. This data is used to ensure that the resource allocation adheres to the campaign's constraints.

### Current Stored Values  
```sql
-- Iteration 1 Realistic Data
-- Generated by triple expert (business + data + optimization)
-- Values were determined based on realistic campaign budgets, historical voter turnout data, and population sizes of typical counties. The proportionality factor was set to ensure fair allocation relative to population.

-- Realistic data for expected_turnout_per_dollar
INSERT INTO expected_turnout_per_dollar (County_Id, turnout_per_dollar) VALUES (1, 0.55);
INSERT INTO expected_turnout_per_dollar (County_Id, turnout_per_dollar) VALUES (2, 0.65);
INSERT INTO expected_turnout_per_dollar (County_Id, turnout_per_dollar) VALUES (3, 0.45);

-- Realistic data for resource_allocation_limits
INSERT INTO resource_allocation_limits (County_Id, allocation) VALUES (1, 15000);
INSERT INTO resource_allocation_limits (County_Id, allocation) VALUES (2, 25000);
INSERT INTO resource_allocation_limits (County_Id, allocation) VALUES (3, 10000);
```