# Complete Optimization Problem and Solution: employee_hire_evaluation

## 1. Problem Context and Goals

### Context  
A retail chain is focused on optimizing its employee hiring and allocation strategy across multiple shops to minimize total hiring costs while ensuring each shop meets its staffing requirements. The business decisions involve determining the number of full-time and part-time employees to hire for each shop, as well as deciding which employees should receive bonuses based on their performance evaluations.  

The cost of hiring a full-time employee varies by shop, with each shop having a specific cost per full-time employee. Similarly, the cost of hiring a part-time employee also varies by shop. These costs are critical inputs to the optimization problem, as they directly influence the total hiring expenses.  

The business configuration includes the following operational parameters:  
- **Cost per full-time employee for each shop**: This represents the expense associated with hiring a full-time employee at a specific shop.  
- **Cost per part-time employee for each shop**: This represents the expense associated with hiring a part-time employee at a specific shop.  

The optimization problem is designed to ensure that each shop has sufficient staff to meet its operational needs while adhering to limits on the number of full-time and part-time employees that can be hired. The problem avoids scenarios that would require nonlinear relationships, such as variable products or divisions, ensuring a linear formulation.  

### Goals  
The primary goal of this optimization problem is to minimize the total hiring costs across all shops. This is achieved by carefully deciding the number of full-time and part-time employees to hire for each shop, taking into account the specific costs associated with each type of hire.  

Success is measured by the ability to reduce total hiring expenses while ensuring that each shop meets its minimum staffing requirements and does not exceed the maximum allowed number of full-time or part-time employees. The optimization goal is directly aligned with the operational parameters, ensuring a clear and linear relationship between the decisions and the objective.  

## 2. Constraints  

The optimization problem is subject to the following constraints, which ensure that the staffing decisions align with business requirements:  

1. **Minimum Staffing Requirement**: For each shop, the total number of full-time and part-time employees hired must meet or exceed the minimum staffing requirement. This ensures that each shop has sufficient staff to operate effectively.  

2. **Maximum Full-Time Employees**: For each shop, the number of full-time employees hired must not exceed the maximum allowed number of full-time employees. This ensures compliance with business policies regarding full-time staffing levels.  

3. **Maximum Part-Time Employees**: For each shop, the number of part-time employees hired must not exceed the maximum allowed number of part-time employees. This ensures compliance with business policies regarding part-time staffing levels.  

These constraints are designed to naturally lead to linear mathematical forms, avoiding any complexity that would require nonlinear relationships.  

## 3. Available Data  

### Database Schema  
```sql
-- Iteration 3 Database Schema
-- Objective: Schema changes include creating a new table for objective coefficients (cost_full_time and cost_part_time) and updating business configuration logic to ensure all optimization requirements are mapped. Existing tables and configuration logic are reviewed for completeness and alignment with OR expert's analysis.

CREATE TABLE shop_staff_requirements (
  shop_id INTEGER,
  min_staff INTEGER,
  max_full_time INTEGER,
  max_part_time INTEGER
);

CREATE TABLE employee_bonus_decisions (
  employee_id INTEGER,
  y BOOLEAN
);

CREATE TABLE employee_hiring_decisions (
  shop_id INTEGER,
  x_full_time INTEGER,
  x_part_time INTEGER
);

CREATE TABLE employee_costs (
  shop_id INTEGER,
  cost_full_time INTEGER,
  cost_part_time INTEGER
);
```

### Data Dictionary  
The following tables and columns are critical to the optimization problem, with their business purposes and optimization roles clearly defined:  

- **shop_staff_requirements**:  
  - **shop_id**: Unique identifier for each shop.  
  - **min_staff**: Minimum number of employees required for the shop to operate effectively.  
  - **max_full_time**: Maximum number of full-time employees allowed for the shop.  
  - **max_part_time**: Maximum number of part-time employees allowed for the shop.  

- **employee_bonus_decisions**:  
  - **employee_id**: Unique identifier for each employee.  
  - **y**: Binary decision indicating whether a bonus is awarded to the employee.  

- **employee_hiring_decisions**:  
  - **shop_id**: Unique identifier for each shop.  
  - **x_full_time**: Number of full-time employees to hire for the shop.  
  - **x_part_time**: Number of part-time employees to hire for the shop.  

- **employee_costs**:  
  - **shop_id**: Unique identifier for each shop.  
  - **cost_full_time**: Cost per full-time employee for the shop.  
  - **cost_part_time**: Cost per part-time employee for the shop.  

### Current Stored Values  
```sql
-- Iteration 3 Realistic Data
-- Generated by triple expert (business + data + optimization)
-- Values were determined based on industry standards for retail staffing and costs, ensuring realistic and meaningful data for optimization.

-- Realistic data for shop_staff_requirements
INSERT INTO shop_staff_requirements (shop_id, min_staff, max_full_time, max_part_time) VALUES (1, 5, 10, 8);
INSERT INTO shop_staff_requirements (shop_id, min_staff, max_full_time, max_part_time) VALUES (2, 6, 12, 10);
INSERT INTO shop_staff_requirements (shop_id, min_staff, max_full_time, max_part_time) VALUES (3, 7, 15, 12);

-- Realistic data for employee_bonus_decisions
INSERT INTO employee_bonus_decisions (employee_id, y) VALUES (101, True);
INSERT INTO employee_bonus_decisions (employee_id, y) VALUES (102, False);
INSERT INTO employee_bonus_decisions (employee_id, y) VALUES (103, True);

-- Realistic data for employee_hiring_decisions
INSERT INTO employee_hiring_decisions (shop_id, x_full_time, x_part_time) VALUES (1, 2, 3);
INSERT INTO employee_hiring_decisions (shop_id, x_full_time, x_part_time) VALUES (2, 3, 4);
INSERT INTO employee_hiring_decisions (shop_id, x_full_time, x_part_time) VALUES (3, 4, 5);

-- Realistic data for employee_costs
INSERT INTO employee_costs (shop_id, cost_full_time, cost_part_time) VALUES (1, 1500, 800);
INSERT INTO employee_costs (shop_id, cost_full_time, cost_part_time) VALUES (2, 1600, 850);
INSERT INTO employee_costs (shop_id, cost_full_time, cost_part_time) VALUES (3, 1700, 900);
```