# Complete Optimization Problem and Solution: entertainment_awards

## 1. Problem Context and Goals

### Context  
The film festival aims to maximize audience engagement by selecting a subset of artworks to nominate for each festival. The decision to nominate an artwork is binary, meaning each artwork can either be nominated or not for a specific festival. The engagement score for each artwork at a festival reflects its potential to attract and engage the audience. The festival must also adhere to two key operational constraints:  
1. **Maximum Nominations per Festival**: Each festival has a predefined limit on the number of artworks that can be nominated.  
2. **Minimum Diversity Requirement**: The nominated artworks must collectively meet a minimum diversity score, ensuring a balanced representation of different artwork types.  

The business configuration includes a scalar parameter, the minimum required diversity score, which is set to 0.75. This ensures that the selection of artworks maintains a moderate level of diversity while maximizing audience engagement.  

### Goals  
The primary goal of this optimization problem is to maximize the total audience engagement across all festivals. This is achieved by selecting the optimal set of artworks to nominate, considering their engagement scores and adhering to the operational constraints. Success is measured by the sum of engagement scores for the nominated artworks, ensuring that the festival’s audience engagement is as high as possible while respecting the nomination limits and diversity requirements.  

## 2. Constraints  

The optimization problem is subject to the following constraints:  
1. **Maximum Nominations per Festival**: For each festival, the total number of nominated artworks cannot exceed the predefined maximum number of nominations allowed for that festival.  
2. **Minimum Diversity Requirement**: For each festival, the combined diversity score of the nominated artworks must meet or exceed the minimum required diversity score of 0.75. This ensures a balanced selection of artwork types.  

These constraints are designed to ensure that the festival’s operational limits and diversity goals are met while maximizing audience engagement.  

## 3. Available Data  

### Database Schema  
```sql
-- Iteration 3 Database Schema
-- Objective: Schema changes include adding a minimum diversity score constraint to the business configuration logic and updating the data dictionary to reflect this addition. No new tables were created or deleted as the existing schema adequately supports the optimization requirements.

CREATE TABLE engagement_scores (
  Artwork_ID INTEGER,
  Festival_ID INTEGER,
  score FLOAT
);

CREATE TABLE festival_nominations (
  Festival_ID INTEGER,
  max_nominations INTEGER
);

CREATE TABLE artwork_types (
  Type STRING,
  diversity_score FLOAT
);

CREATE TABLE nomination_decisions (
  Artwork_ID INTEGER,
  Festival_ID INTEGER,
  decision BOOLEAN
);
```

### Data Dictionary  
- **engagement_scores**: Contains the engagement scores for artworks at specific festivals.  
  - *Artwork_ID*: Unique identifier for the artwork.  
  - *Festival_ID*: Unique identifier for the festival.  
  - *score*: Engagement score for the artwork at the festival, used as the coefficient in the optimization objective.  

- **festival_nominations**: Defines the maximum number of nominations allowed per festival.  
  - *Festival_ID*: Unique identifier for the festival.  
  - *max_nominations*: Maximum number of nominations allowed for the festival, used as a constraint bound.  

- **artwork_types**: Lists the types of artworks and their associated diversity scores.  
  - *Type*: Type of artwork (e.g., Film, Short, Documentary).  
  - *diversity_score*: Diversity score for the artwork type, used in the diversity constraint.  

- **nomination_decisions**: Represents the binary decision variable indicating whether an artwork is nominated at a festival.  
  - *Artwork_ID*: Unique identifier for the artwork.  
  - *Festival_ID*: Unique identifier for the festival.  
  - *decision*: Binary decision (True/False) indicating whether the artwork is nominated.  

### Current Stored Values  
```sql
-- Iteration 3 Realistic Data
-- Generated by triple expert (business + data + optimization)
-- Values were determined based on realistic film festival scenarios, ensuring diversity in artwork types and engagement scores that reflect audience preferences. Constraints were respected to ensure the optimization problem remains solvable.

-- Realistic data for engagement_scores
INSERT INTO engagement_scores (Artwork_ID, Festival_ID, score) VALUES (1, 1, 0.85);
INSERT INTO engagement_scores (Artwork_ID, Festival_ID, score) VALUES (2, 1, 0.75);
INSERT INTO engagement_scores (Artwork_ID, Festival_ID, score) VALUES (3, 1, 0.65);

-- Realistic data for festival_nominations
INSERT INTO festival_nominations (Festival_ID, max_nominations) VALUES (1, 5);
INSERT INTO festival_nominations (Festival_ID, max_nominations) VALUES (2, 6);
INSERT INTO festival_nominations (Festival_ID, max_nominations) VALUES (3, 4);

-- Realistic data for artwork_types
INSERT INTO artwork_types (Type, diversity_score) VALUES ('Film', 0.9);
INSERT INTO artwork_types (Type, diversity_score) VALUES ('Short', 0.8);
INSERT INTO artwork_types (Type, diversity_score) VALUES ('Documentary', 0.7);

-- Realistic data for nomination_decisions
INSERT INTO nomination_decisions (Artwork_ID, Festival_ID, decision) VALUES (1, 1, True);
INSERT INTO nomination_decisions (Artwork_ID, Festival_ID, decision) VALUES (2, 1, False);
INSERT INTO nomination_decisions (Artwork_ID, Festival_ID, decision) VALUES (3, 1, True);
```