# Complete Optimization Problem and Solution: epinions_1

## 1. Problem Context and Goals

### Context  
The platform operates in a business environment where users provide reviews, and other users rely on these reviews to make informed decisions. To enhance the reliability of these reviews, the platform aims to assign trust weights to reviews based on the trust levels between users. These trust weights reflect the confidence a user has in the reviewer's opinion. The platform's goal is to maximize the overall trust-weighted ratings of reviews, ensuring that the weights are non-negative and do not exceed the trust levels between users. This approach ensures that reviews from highly trusted users have a more significant impact on the overall rating.

The business configuration includes a maximum allowable trust weight for a review, which is set to 1.0. This parameter ensures that the trust weights remain realistic and feasible, aligning with the highest possible trust level between users. The decision variables in this optimization problem are the continuous trust weights assigned to each review, and the objective is to maximize the sum of the trust-weighted ratings of all reviews.

### Goals  
The primary goal of this optimization problem is to maximize the overall trust-weighted ratings of reviews on the platform. This is achieved by assigning optimal trust weights to each review based on the trust levels between users. The success of this optimization is measured by the total sum of the trust-weighted ratings, where each review's rating is multiplied by its corresponding trust weight. The platform aims to ensure that the trust weights are non-negative and do not exceed the trust levels between users, thereby maintaining the integrity and reliability of the reviews.

## 2. Constraints    

The optimization problem is subject to two main constraints:

1. **Non-Negative Trust Weights**: The trust weight assigned to each review must be non-negative. This ensures that the impact of a review on the overall rating is always positive or neutral, reflecting the platform's commitment to maintaining the integrity of the review system.

2. **Trust Weight Upper Bound**: The trust weight assigned to each review must not exceed the trust level between the reviewer and the user. This constraint ensures that the trust weights are realistic and feasible, aligning with the actual trust levels between users. The maximum allowable trust weight for a review is set to 1.0, as defined in the business configuration.

These constraints ensure that the trust weights are within acceptable limits and that the optimization problem remains linear, avoiding any nonlinear relationships such as variable products or divisions.

## 3. Available Data  

### Database Schema  
```sql
-- Iteration 1 Database Schema
-- Objective: Schema changes include adding a trust_weight table for decision variables, updating the review table to include optimization-relevant data, and moving scalar parameters to business_configuration_logic.json.

CREATE TABLE trust_weight (
  weight FLOAT
);

CREATE TABLE review (
  rating FLOAT
);

CREATE TABLE trust (
  trust FLOAT
);
```

### Data Dictionary  
- **trust_weight Table**:  
  - **Business Purpose**: Stores the trust weights assigned to reviews.  
  - **Optimization Role**: Decision variables in the optimization model.  
  - **Columns**:  
    - **weight**: The weight assigned to a review based on trust. This is a continuous variable that directly influences the optimization objective.

- **review Table**:  
  - **Business Purpose**: Stores review data, including ratings provided by users.  
  - **Optimization Role**: Provides the coefficients for the objective function.  
  - **Columns**:  
    - **rating**: The rating of the review by the author. This value is used as a coefficient in the objective function to calculate the trust-weighted ratings.

- **trust Table**:  
  - **Business Purpose**: Stores the trust levels between users.  
  - **Optimization Role**: Provides the bounds for the constraints.  
  - **Columns**:  
    - **trust**: The trust level between the source and target user. This value is used to set the upper bound for the trust weights in the constraints.

### Current Stored Values  
```sql
-- Iteration 1 Realistic Data
-- Generated by triple expert (business + data + optimization)
-- Values were determined based on realistic user interactions, trust levels, and review ratings, ensuring they align with the business context of maximizing trust-weighted ratings.

-- Realistic data for trust_weight
INSERT INTO trust_weight (weight) VALUES (0.5);
INSERT INTO trust_weight (weight) VALUES (0.7);
INSERT INTO trust_weight (weight) VALUES (0.9);

-- Realistic data for review
INSERT INTO review (rating) VALUES (4.5);
INSERT INTO review (rating) VALUES (3.8);
INSERT INTO review (rating) VALUES (5.0);
INSERT INTO review (rating) VALUES (3.0);
INSERT INTO review (rating) VALUES (4.0);

-- Realistic data for trust
INSERT INTO trust (trust) VALUES (0.6);
INSERT INTO trust (trust) VALUES (0.8);
INSERT INTO trust (trust) VALUES (1.0);
INSERT INTO trust (trust) VALUES (0.7);
```