# Complete Optimization Problem and Solution: game_1

## 1. Problem Context and Goals

### Context  
A university is tasked with optimizing the allocation of scholarships to students based on three key factors: academic performance, sports participation, and gaming habits. The goal is to maximize overall student satisfaction and performance while adhering to budget constraints and ensuring fairness in scholarship distribution. The university has a total budget of $150,000 available for scholarships, and a factor of 1000 is applied to ensure that students with higher GPAs receive proportionally more scholarships.  

The decision variables in this problem are the scholarship amounts allocated to each student, which are continuous values. The operational parameters include the weights assigned to academic performance (GPA), sports participation (hours per week), and gaming habits (hours played). These weights are used to calculate a weighted sum that represents the overall satisfaction and performance of students.  

The problem is designed to avoid nonlinear relationships, ensuring that all calculations and constraints are linear. For example, the scholarship amount for each student is directly proportional to their GPA, and the total scholarship allocation must not exceed the available budget. Additionally, students must meet minimum and maximum hour requirements for both sports participation and gaming to be eligible for scholarships.  

### Goals  
The primary goal of this optimization problem is to maximize the total weighted sum of student satisfaction, which is influenced by academic performance, sports participation, and gaming habits. Success is measured by how well the scholarship allocations align with the weighted contributions of these factors.  

The optimization aims to ensure that students with higher GPAs receive more scholarships, while also considering their involvement in sports and gaming. The weights assigned to each factor (GPA, sports participation, and gaming habits) are critical in determining the final allocation. The university seeks to achieve a fair and balanced distribution of scholarships that encourages both academic excellence and extracurricular engagement.  

## 2. Constraints  

The optimization problem is subject to the following constraints:  
1. **Total Budget Constraint**: The sum of all scholarship amounts allocated to students must not exceed the total budget of $150,000.  
2. **Scholarship Fairness Constraint**: Each student's scholarship amount must be at least proportional to their GPA, using a factor of 1000 to ensure higher GPA students receive more scholarships.  
3. **Sports Participation Constraints**: Each student must meet the minimum and maximum hour requirements for sports participation. These requirements ensure that students are actively engaged in sports without overcommitting.  
4. **Gaming Habits Constraints**: Each student must meet the minimum and maximum hour requirements for gaming. These requirements ensure that students maintain a balanced lifestyle while still enjoying gaming activities.  

These constraints are designed to ensure that the scholarship allocations are fair, feasible, and aligned with the university's priorities.  

## 3. Available Data  

### Database Schema  
```sql
-- Iteration 3 Database Schema
-- Objective: Schema changes include adding missing optimization requirements to business configuration logic and ensuring all mappings are complete.

CREATE TABLE Academic_Performance (
  Student_ID INTEGER,
  GPA FLOAT
);

CREATE TABLE Objective_Weights (
  w1 FLOAT,
  w2 FLOAT,
  w3 FLOAT
);

CREATE TABLE SportsInfo (
  Student_ID INTEGER,
  HoursPerWeek FLOAT,
  Min_Hours_Sports FLOAT,
  Max_Hours_Sports FLOAT
);

CREATE TABLE Plays_Games (
  Student_ID INTEGER,
  Hours_Played FLOAT,
  Min_Hours_Gaming FLOAT,
  Max_Hours_Gaming FLOAT
);

CREATE TABLE Scholarship_Allocation (
  Student_ID INTEGER,
  Scholarship_Amount FLOAT
);
```

### Data Dictionary  
- **Academic_Performance**:  
  - **Student_ID**: Unique identifier for each student.  
  - **GPA**: Grade Point Average of the student, used to determine academic performance and scholarship allocation.  

- **Objective_Weights**:  
  - **w1**: Weight assigned to academic performance in the objective function.  
  - **w2**: Weight assigned to sports participation in the objective function.  
  - **w3**: Weight assigned to gaming habits in the objective function.  

- **SportsInfo**:  
  - **Student_ID**: Unique identifier for each student.  
  - **HoursPerWeek**: Hours spent on sports per week, used in the objective function and constraints.  
  - **Min_Hours_Sports**: Minimum hours required for sports participation, used as a constraint bound.  
  - **Max_Hours_Sports**: Maximum hours allowed for sports participation, used as a constraint bound.  

- **Plays_Games**:  
  - **Student_ID**: Unique identifier for each student.  
  - **Hours_Played**: Hours spent on gaming per week, used in the objective function and constraints.  
  - **Min_Hours_Gaming**: Minimum hours required for gaming, used as a constraint bound.  
  - **Max_Hours_Gaming**: Maximum hours allowed for gaming, used as a constraint bound.  

- **Scholarship_Allocation**:  
  - **Student_ID**: Unique identifier for each student.  
  - **Scholarship_Amount**: Scholarship amount allocated to the student, which is the decision variable in the optimization model.  

### Current Stored Values  
```sql
-- Iteration 3 Realistic Data
-- Generated by triple expert (business + data + optimization)
-- Values were determined based on realistic university scholarship allocation scenarios, considering typical GPA ranges, sports and gaming participation hours, and budget constraints.

-- Realistic data for Academic_Performance
INSERT INTO Academic_Performance (Student_ID, GPA) VALUES (1, 3.8);
INSERT INTO Academic_Performance (Student_ID, GPA) VALUES (2, 3.5);
INSERT INTO Academic_Performance (Student_ID, GPA) VALUES (3, 3.2);

-- Realistic data for Objective_Weights
INSERT INTO Objective_Weights (w1, w2, w3) VALUES (0.6, 0.25, 0.15);
INSERT INTO Objective_Weights (w1, w2, w3) VALUES (0.5, 0.3, 0.2);
INSERT INTO Objective_Weights (w1, w2, w3) VALUES (0.4, 0.35, 0.25);

-- Realistic data for SportsInfo
INSERT INTO SportsInfo (Student_ID, HoursPerWeek, Min_Hours_Sports, Max_Hours_Sports) VALUES (1, 10.0, 2.0, 15.0);
INSERT INTO SportsInfo (Student_ID, HoursPerWeek, Min_Hours_Sports, Max_Hours_Sports) VALUES (2, 7.5, 2.5, 18.0);
INSERT INTO SportsInfo (Student_ID, HoursPerWeek, Min_Hours_Sports, Max_Hours_Sports) VALUES (3, 5.0, 3.0, 20.0);

-- Realistic data for Plays_Games
INSERT INTO Plays_Games (Student_ID, Hours_Played, Min_Hours_Gaming, Max_Hours_Gaming) VALUES (1, 12.5, 5.0, 20.0);
INSERT INTO Plays_Games (Student_ID, Hours_Played, Min_Hours_Gaming, Max_Hours_Gaming) VALUES (2, 15.0, 6.0, 25.0);
INSERT INTO Plays_Games (Student_ID, Hours_Played, Min_Hours_Gaming, Max_Hours_Gaming) VALUES (3, 10.0, 5.5, 22.0);

-- Realistic data for Scholarship_Allocation
INSERT INTO Scholarship_Allocation (Student_ID, Scholarship_Amount) VALUES (1, 3000.0);
INSERT INTO Scholarship_Allocation (Student_ID, Scholarship_Amount) VALUES (2, 2000.0);
INSERT INTO Scholarship_Allocation (Student_ID, Scholarship_Amount) VALUES (3, 1000.0);
```