# Complete Optimization Problem and Solution: gas_company

## 1. Problem Context and Goals

### Context  
A gas company is focused on optimizing the allocation of its gas stations to different companies to maximize overall profits. The company must decide which gas station should be assigned to which company, considering the potential profit each station can generate for a specific company. Each gas station can only be assigned to one company at a time, ensuring no overlaps in ownership. Additionally, the company must respect the maximum rank of each company, which limits the total number of gas stations a company can manage. The maximum rank is a predefined value that reflects the company's capacity to handle stations without overextending its resources. For example, a company with a maximum rank of 150 can manage up to 150 gas stations. This ensures that the allocation is both profitable and operationally feasible.

### Goals  
The primary goal is to maximize the total profit generated from the allocation of gas stations to companies. This is achieved by assigning each gas station to the company that yields the highest profit while ensuring that no station is assigned to more than one company and that no company exceeds its maximum rank. Success is measured by the total profit generated from the assignments, which is directly influenced by the profit values associated with each station-company pair.

## 2. Constraints    

1. **Single Assignment Constraint**: Each gas station can be assigned to at most one company. This ensures that no station is shared or duplicated across multiple companies, maintaining clear ownership and operational boundaries.  
2. **Maximum Rank Constraint**: The total number of gas stations assigned to a company cannot exceed its maximum rank. This ensures that companies do not overextend their capacity and can effectively manage the stations assigned to them.  

These constraints ensure that the allocation is both profitable and operationally feasible, aligning with the company's business objectives and resource limitations.

## 3. Available Data  

### Database Schema  
```sql
-- Iteration 1 Database Schema
-- Objective: Schema changes and configuration logic updates implemented to address missing profit and rank data, ensuring complete optimization model mapping.

CREATE TABLE station_profit (
  station_id INTEGER,
  company_id INTEGER,
  profit FLOAT,
  assignment BOOLEAN
);

CREATE TABLE company_rank (
  company_id INTEGER,
  max_rank INTEGER
);
```

### Data Dictionary  
- **station_profit**: This table contains information about the profit generated by each gas station when assigned to a specific company.  
  - **station_id**: A unique identifier for each gas station.  
  - **company_id**: A unique identifier for each company.  
  - **profit**: The profit generated when a specific gas station is assigned to a specific company. This value is used as a coefficient in the optimization objective.  
  - **assignment**: A binary indicator that determines whether a gas station is assigned to a company. This is the decision variable in the optimization problem.  

- **company_rank**: This table defines the maximum rank allowed for each company, which limits the number of gas stations a company can manage.  
  - **company_id**: A unique identifier for each company.  
  - **max_rank**: The maximum number of gas stations a company can manage. This value is used as a constraint bound in the optimization problem.  

### Current Stored Values  
```sql
-- Iteration 1 Realistic Data
-- Generated by triple expert (business + data + optimization)
-- Values were determined based on realistic business scenarios, considering the size of gas stations, company capacities, and profit margins. The data ensures that the optimization problem is meaningful and solvable by providing a range of profits and ranks that reflect real-world variability.

-- Realistic data for station_profit
INSERT INTO station_profit (station_id, company_id, profit, assignment) VALUES (1, 1, 5000.0, False);
INSERT INTO station_profit (station_id, company_id, profit, assignment) VALUES (2, 2, 7500.0, True);
INSERT INTO station_profit (station_id, company_id, profit, assignment) VALUES (3, 3, 10000.0, False);

-- Realistic data for company_rank
INSERT INTO company_rank (company_id, max_rank) VALUES (1, 100);
INSERT INTO company_rank (company_id, max_rank) VALUES (2, 150);
INSERT INTO company_rank (company_id, max_rank) VALUES (3, 200);
```