# Complete Optimization Problem and Solution: inn_1

## 1. Problem Context and Goals

### Context  
The business operates a hotel and seeks to optimize room allocation decisions to maximize revenue while adhering to operational constraints. The primary decision involves determining whether to accept or reject each reservation request. Each reservation has an associated rate, which represents the revenue generated if the reservation is accepted. The hotel has a fixed maximum occupancy per room, ensuring that the number of guests does not exceed the room's capacity. Additionally, the system must prevent double-booking by ensuring that no two reservations for the same room overlap in their check-in and check-out dates.  

The business configuration includes a maximum occupancy limit of 4 guests per room, which serves as a constraint on the total number of guests that can be accommodated. The system also employs a formula to detect overlapping reservation dates, ensuring that only one reservation is accepted for any given room during the same time period. These constraints are designed to maintain operational feasibility while maximizing revenue.  

The optimization problem is formulated linearly, focusing on straightforward relationships between decision variables, revenue, and constraints. This ensures that the problem remains computationally tractable and aligned with business needs.  

### Goals  
The primary goal of this optimization problem is to maximize the total revenue generated from accepted reservations. This is achieved by strategically deciding which reservations to accept, based on their associated rates, while ensuring that room capacities are not exceeded and that no double-booking occurs. Success is measured by the total revenue generated, which is directly tied to the rates of the accepted reservations. The optimization process aims to make decisions that align with these objectives, ensuring that the hotel operates efficiently and profitably.  

## 2. Constraints  

The optimization problem is subject to the following constraints:  

1. **Room Capacity Constraint**: The total number of guests across all accepted reservations for a room must not exceed the maximum occupancy limit of 4 guests. This ensures that the room is not overbooked and that guest comfort and safety are maintained.  

2. **Date Overlap Constraint**: For any two reservations that overlap in their check-in and check-out dates, only one of them can be accepted. This prevents double-booking and ensures that each room is allocated to only one reservation at any given time.  

These constraints are designed to reflect real-world operational limitations and are expressed in a way that naturally leads to a linear optimization formulation.  

## 3. Available Data  

### Database Schema  
```sql
-- Iteration 1 Database Schema
-- Objective: Schema changes include adding a new table for decision variables and updating configuration logic to handle date overlap constraints. Business configuration logic now includes scalar parameters and formulas for optimization.

CREATE TABLE ReservationDecisions (
  AcceptReservation BOOLEAN
);

CREATE TABLE Reservations (
  Rate FLOAT,
  AcceptReservation BOOLEAN
);
```

### Data Dictionary  
- **ReservationDecisions Table**:  
  - **Purpose**: Stores the decision to accept or reject each reservation.  
  - **AcceptReservation Column**:  
    - **Business Meaning**: Indicates whether a reservation is accepted (1) or rejected (0).  
    - **Optimization Role**: Serves as the binary decision variable in the optimization model.  

- **Reservations Table**:  
  - **Purpose**: Stores details of each reservation, including the revenue it generates.  
  - **Rate Column**:  
    - **Business Meaning**: The revenue generated from each reservation.  
    - **Optimization Role**: Used as the coefficient in the objective function to maximize total revenue.  
  - **AcceptReservation Column**:  
    - **Business Meaning**: Indicates whether a reservation is accepted (1) or rejected (0).  
    - **Optimization Role**: Serves as the binary decision variable in the optimization model.  

### Current Stored Values  
```sql
-- Iteration 1 Realistic Data
-- Generated by triple expert (business + data + optimization)
-- Values were determined based on typical hotel room capacities, reservation rates, and realistic booking scenarios to ensure the optimization problem is meaningful and solvable.

-- Realistic data for ReservationDecisions
INSERT INTO ReservationDecisions (AcceptReservation) VALUES (1);
INSERT INTO ReservationDecisions (AcceptReservation) VALUES (0);
INSERT INTO ReservationDecisions (AcceptReservation) VALUES (1);

-- Realistic data for Reservations
INSERT INTO Reservations (Rate, AcceptReservation) VALUES (120.0, 1);
INSERT INTO Reservations (Rate, AcceptReservation) VALUES (100.0, 0);
INSERT INTO Reservations (Rate, AcceptReservation) VALUES (150.0, 1);
INSERT INTO Reservations (Rate, AcceptReservation) VALUES (110.0, 1);
INSERT INTO Reservations (Rate, AcceptReservation) VALUES (130.0, 0);
```