# Complete Optimization Problem and Solution: journal_committee

## 1. Problem Context and Goals

### Context  
A publishing company is focused on maximizing the total sales of its journals by strategically assigning editors to journals. The company ensures that each journal is assigned at least one editor and that no editor is overburdened with too many journals. The decision to assign an editor to a journal is represented by a binary variable, where a value of true indicates an assignment and false indicates no assignment. The company uses the sales figures of each journal as a key metric to drive the optimization process. Additionally, the company has set a maximum workload limit for each editor, ensuring that no editor is assigned more journals than they can handle. The assignment process also considers the expertise of editors, ensuring that editors are matched to journals based on their thematic alignment. This expertise matching is calculated by comparing the editor's expertise theme with the journal's theme, resulting in a binary match indicator. The optimization problem is designed to be linear, avoiding any nonlinear relationships such as variable products or divisions.

### Goals  
The primary goal of this optimization problem is to maximize the total sales of journals by making optimal assignments of editors to journals. Success is measured by the sum of sales from all journals, where each journal's sales figure is multiplied by the assignment decision. The company aims to achieve this goal while respecting the constraints on editor workloads and ensuring that each journal is assigned at least one editor. The optimization process is designed to be linear, focusing on straightforward, additive relationships that align with the company's operational parameters.

## 2. Constraints    

The optimization problem is subject to two key constraints. First, the total number of journals assigned to each editor must not exceed the editor's maximum workload limit. This ensures that no editor is overburdened and can effectively manage their assigned journals. Second, each journal must be assigned at least one editor. This ensures that every journal has the necessary editorial oversight and support. Both constraints are designed to be linear, avoiding any complex relationships or nonlinear interactions.

## 3. Available Data  

### Database Schema  
```sql
-- Iteration 1 Database Schema
-- Objective: Schema changes include creating new tables for editor expertise and workload limits, modifying the journal_committee table to better represent assignments, and adding configuration logic for scalar parameters and formulas.

CREATE TABLE journal (
  Sales FLOAT
);

CREATE TABLE editor_expertise (
  theme STRING
);

CREATE TABLE editor_workload (
  Max_Workload INTEGER
);

CREATE TABLE journal_committee (
  Assign_ej BOOLEAN
);
```

### Data Dictionary  
- **journal**: Stores details about each journal, including its sales figures. The sales figures are used as coefficients in the objective function to maximize total sales.
  - **Sales**: Represents the sales of the journal, used as a coefficient in the objective function.

- **editor_expertise**: Stores information about the expertise of each editor, specifically the themes they are knowledgeable in. This information is used to match editors to journals based on thematic alignment.
  - **theme**: Represents the theme of expertise for an editor, used in the expertise matching formula.

- **editor_workload**: Stores the maximum number of journals each editor can handle. This information is used to set the constraint bounds for editor workloads.
  - **Max_Workload**: Represents the maximum number of journals an editor can handle, used as a constraint bound.

- **journal_committee**: Stores the assignments of editors to journals. The assignment decisions are represented as binary variables in the optimization model.
  - **Assign_ej**: Represents the assignment of an editor to a journal, used as a decision variable in the optimization model.

### Current Stored Values  
```sql
-- Iteration 1 Realistic Data
-- Generated by triple expert (business + data + optimization)
-- Values were determined based on realistic business scenarios, ensuring that editors' workloads are balanced, journals have varying sales figures, and expertise matches are meaningful.

-- Realistic data for journal
INSERT INTO journal (Sales) VALUES (1200.0);
INSERT INTO journal (Sales) VALUES (1800.0);
INSERT INTO journal (Sales) VALUES (900.0);

-- Realistic data for editor_expertise
INSERT INTO editor_expertise (theme) VALUES ('Science');
INSERT INTO editor_expertise (theme) VALUES ('Arts');
INSERT INTO editor_expertise (theme) VALUES ('Technology');

-- Realistic data for editor_workload
INSERT INTO editor_workload (Max_Workload) VALUES (4);
INSERT INTO editor_workload (Max_Workload) VALUES (3);
INSERT INTO editor_workload (Max_Workload) VALUES (5);

-- Realistic data for journal_committee
INSERT INTO journal_committee (Assign_ej) VALUES (True);
INSERT INTO journal_committee (Assign_ej) VALUES (False);
INSERT INTO journal_committee (Assign_ej) VALUES (True);
```