# Complete Optimization Problem and Solution: local_govt_in_alabama

## 1. Problem Context and Goals

### Context  
The local government in Alabama is tasked with optimizing the allocation of participants to events to ensure the highest possible satisfaction among attendees while adhering to operational constraints. The decision to assign a participant to an event is represented as a binary choice: either the participant is assigned (1) or not (0). The goal is to maximize the total satisfaction score across all assignments, where the satisfaction score reflects how much a participant is expected to enjoy a specific event. 

Each event has a predefined capacity, which limits the number of participants that can be assigned to it. This capacity is a critical operational parameter, ensuring that events are not overcrowded and remain manageable. Additionally, each participant can be assigned to at most one event, ensuring fairness and preventing overcommitment. 

The satisfaction scores are derived from historical data and participant preferences, providing a realistic measure of expected enjoyment. The default event capacity is set to 50 participants, a typical size for local government events, ensuring manageable group sizes. This configuration ensures that the optimization problem remains linear, avoiding complex scenarios such as variable products or divisions.

### Goals  
The primary goal of this optimization problem is to maximize the overall satisfaction of participants by assigning them to events in the most effective way. This is achieved by summing the satisfaction scores of all assigned participant-event pairs. Success is measured by the total satisfaction score, which directly reflects the quality of the assignments. The optimization process ensures that the assignments respect event capacities and participant availability, leading to a fair and efficient allocation.

## 2. Constraints  

The optimization problem is subject to two key constraints:  
1. **Event Capacity Constraint**: The total number of participants assigned to any single event must not exceed the event's predefined capacity. This ensures that events remain within manageable limits and do not become overcrowded.  
2. **Participant Assignment Constraint**: Each participant can be assigned to at most one event. This ensures fairness and prevents participants from being overcommitted to multiple events simultaneously.  

These constraints are designed to align with the operational realities of event planning, ensuring that the solution is both practical and effective.

## 3. Available Data  

### Database Schema  
```sql
-- Iteration 1 Database Schema
-- Objective: Added tables for satisfaction scores and event capacities, updated Participants_in_Events table, and created business_configuration_logic.json for scalar parameters and formulas.

CREATE TABLE Satisfaction_Scores (
  Event_ID INTEGER,
  Participant_ID INTEGER,
  Score FLOAT
);

CREATE TABLE Event_Capacities (
  Event_ID INTEGER,
  Capacity INTEGER
);

CREATE TABLE Participants_in_Events (
  Event_ID INTEGER,
  Participant_ID INTEGER
);
```

### Data Dictionary  
- **Satisfaction_Scores**:  
  - **Business Purpose**: Captures the satisfaction score of each participant for each event, reflecting how much a participant is expected to enjoy a specific event.  
  - **Optimization Role**: Provides the coefficients for the objective function, representing the value of assigning a participant to an event.  
  - **Columns**:  
    - **Event_ID**: Unique identifier for the event, linking it to the optimization model.  
    - **Participant_ID**: Unique identifier for the participant, linking them to the optimization model.  
    - **Score**: The satisfaction score of the participant for the event, used as a coefficient in the objective function.  

- **Event_Capacities**:  
  - **Business Purpose**: Defines the maximum number of participants allowed in each event, ensuring events remain within manageable limits.  
  - **Optimization Role**: Provides the bounds for the event capacity constraints.  
  - **Columns**:  
    - **Event_ID**: Unique identifier for the event, linking it to the optimization model.  
    - **Capacity**: The maximum number of participants allowed in the event, used as a bound in the capacity constraint.  

- **Participants_in_Events**:  
  - **Business Purpose**: Represents the assignment of participants to events, capturing the decision to assign a participant to an event.  
  - **Optimization Role**: Represents the binary decision variables in the optimization model.  
  - **Columns**:  
    - **Event_ID**: Unique identifier for the event, linking it to the optimization model.  
    - **Participant_ID**: Unique identifier for the participant, linking them to the optimization model.  

### Current Stored Values  
```sql
-- Iteration 1 Realistic Data
-- Generated by triple expert (business + data + optimization)
-- Values were determined based on realistic event sizes, participant preferences, and typical satisfaction scores in local government settings.

-- Realistic data for Satisfaction_Scores
INSERT INTO Satisfaction_Scores (Event_ID, Participant_ID, Score) VALUES (1, 101, 0.85);
INSERT INTO Satisfaction_Scores (Event_ID, Participant_ID, Score) VALUES (1, 102, 0.75);
INSERT INTO Satisfaction_Scores (Event_ID, Participant_ID, Score) VALUES (1, 103, 0.65);
INSERT INTO Satisfaction_Scores (Event_ID, Participant_ID, Score) VALUES (2, 101, 0.7);
INSERT INTO Satisfaction_Scores (Event_ID, Participant_ID, Score) VALUES (2, 102, 0.9);
INSERT INTO Satisfaction_Scores (Event_ID, Participant_ID, Score) VALUES (2, 103, 0.8);
INSERT INTO Satisfaction_Scores (Event_ID, Participant_ID, Score) VALUES (3, 101, 0.6);
INSERT INTO Satisfaction_Scores (Event_ID, Participant_ID, Score) VALUES (3, 102, 0.85);
INSERT INTO Satisfaction_Scores (Event_ID, Participant_ID, Score) VALUES (3, 103, 0.95);

-- Realistic data for Event_Capacities
INSERT INTO Event_Capacities (Event_ID, Capacity) VALUES (1, 50);
INSERT INTO Event_Capacities (Event_ID, Capacity) VALUES (2, 100);
INSERT INTO Event_Capacities (Event_ID, Capacity) VALUES (3, 75);

-- Realistic data for Participants_in_Events
INSERT INTO Participants_in_Events (Event_ID, Participant_ID) VALUES (1, 101);
INSERT INTO Participants_in_Events (Event_ID, Participant_ID) VALUES (1, 102);
INSERT INTO Participants_in_Events (Event_ID, Participant_ID) VALUES (1, 103);
INSERT INTO Participants_in_Events (Event_ID, Participant_ID) VALUES (2, 101);
INSERT INTO Participants_in_Events (Event_ID, Participant_ID) VALUES (2, 102);
INSERT INTO Participants_in_Events (Event_ID, Participant_ID) VALUES (2, 103);
INSERT INTO Participants_in_Events (Event_ID, Participant_ID) VALUES (3, 101);
INSERT INTO Participants_in_Events (Event_ID, Participant_ID) VALUES (3, 102);
INSERT INTO Participants_in_Events (Event_ID, Participant_ID) VALUES (3, 103);
```