# Complete Optimization Problem and Solution: manufacturer

## 1. Problem Context and Goals

### Context  
A furniture manufacturer is tasked with determining the optimal number of units to produce for each furniture type to maximize profit. The decision involves balancing production costs, market rates, and resource limitations. The manufacturer operates under two key constraints: the total production capacity across all factories is limited to 1,000 units, and the total budget available for production is capped at $50,000.  

The profit for each furniture type is calculated as the difference between its market rate and its production cost. The manufacturer aims to allocate production quantities in a way that maximizes total profit while staying within the factory capacity and budget limits. This problem is formulated as a linear optimization model, ensuring that all relationships and constraints are linear and directly tied to operational parameters.  

### Goals  
The primary goal is to maximize the total profit from furniture production. This is achieved by optimizing the number of units produced for each furniture type, considering the difference between the market rate and the production cost for each item. Success is measured by the total profit generated, which is directly influenced by the production quantities and the operational parameters of market rates, production costs, and resource constraints.  

## 2. Constraints  

The manufacturer must adhere to the following constraints:  
1. **Total Production Capacity**: The sum of units produced across all furniture types must not exceed the total factory capacity of 1,000 units. This ensures that production does not surpass the manufacturer's operational capabilities.  
2. **Budget Limit**: The total cost of production, calculated as the sum of the production cost multiplied by the number of units produced for each furniture type, must not exceed the available budget of $50,000. This ensures that production remains financially feasible.  

These constraints are linear and directly tied to the manufacturer's operational limitations, ensuring a realistic and feasible optimization problem.  

## 3. Available Data  

### Database Schema  
```sql
-- Iteration 2 Database Schema
-- Objective: Schema changes include creating tables for objective coefficients (Market_Rate and Price_in_Dollar) and updating business configuration logic to include scalar parameters and formulas for missing optimization requirements.

CREATE TABLE production_plan (
  Furniture_ID INTEGER,
  Quantity_Produced INTEGER
);

CREATE TABLE furniture_market_rates (
  Furniture_ID INTEGER,
  Market_Rate FLOAT
);

CREATE TABLE furniture_production_costs (
  Furniture_ID INTEGER,
  Price_in_Dollar FLOAT
);
```

### Data Dictionary  
- **production_plan**:  
  - **Furniture_ID**: Unique identifier for each furniture type.  
  - **Quantity_Produced**: Number of units to produce for each furniture type. This is the decision variable in the optimization model.  

- **furniture_market_rates**:  
  - **Furniture_ID**: Unique identifier for each furniture type.  
  - **Market_Rate**: Market rate for each furniture type. This is used as an objective coefficient in the optimization model.  

- **furniture_production_costs**:  
  - **Furniture_ID**: Unique identifier for each furniture type.  
  - **Price_in_Dollar**: Production cost for each furniture type. This is used as an objective coefficient in the optimization model.  

### Current Stored Values  
```sql
-- Iteration 2 Realistic Data
-- Generated by triple expert (business + data + optimization)
-- Values were determined based on typical furniture manufacturing scenarios, considering production costs, market rates, and factory capacities. The data ensures a balanced optimization problem with feasible constraints.

-- Realistic data for production_plan
INSERT INTO production_plan (Furniture_ID, Quantity_Produced) VALUES (1, 0);
INSERT INTO production_plan (Furniture_ID, Quantity_Produced) VALUES (2, 0);
INSERT INTO production_plan (Furniture_ID, Quantity_Produced) VALUES (3, 0);

-- Realistic data for furniture_market_rates
INSERT INTO furniture_market_rates (Furniture_ID, Market_Rate) VALUES (1, 120.0);
INSERT INTO furniture_market_rates (Furniture_ID, Market_Rate) VALUES (2, 180.0);
INSERT INTO furniture_market_rates (Furniture_ID, Market_Rate) VALUES (3, 250.0);

-- Realistic data for furniture_production_costs
INSERT INTO furniture_production_costs (Furniture_ID, Price_in_Dollar) VALUES (1, 60.0);
INSERT INTO furniture_production_costs (Furniture_ID, Price_in_Dollar) VALUES (2, 90.0);
INSERT INTO furniture_production_costs (Furniture_ID, Price_in_Dollar) VALUES (3, 130.0);
```