# Complete Optimization Problem and Solution: medicine_enzyme_interaction

## 1. Problem Context and Goals

### Context  
A pharmaceutical company is preparing for a clinical trial and needs to select a combination of medicines that maximizes the overall effectiveness of the treatment while ensuring patient safety and managing trial complexity. Each medicine has a known effectiveness score, which quantifies its potential benefit, and an adverse interaction score, which measures its potential risks when combined with other medicines. The company must decide which medicines to include in the trial, with the decision for each medicine being binary—either it is selected or it is not.

The selection process is guided by two critical operational parameters:  
1. **Maximum Allowed Total Adverse Interaction Score**: The total adverse interaction score of all selected medicines must not exceed 0.5, ensuring patient safety.  
2. **Maximum Number of Medicines That Can Be Selected**: No more than 3 medicines can be included in the trial to manage complexity and resource allocation.  

Additionally, only medicines that are FDA-approved are eligible for selection. The company aims to make these decisions in a way that maximizes the total effectiveness score of the selected medicines while adhering to these constraints.

### Goals  
The primary goal of this optimization problem is to maximize the total effectiveness score of the medicines selected for the clinical trial. This is achieved by carefully choosing which medicines to include, ensuring that their combined effectiveness is as high as possible. Success is measured by the sum of the effectiveness scores of the selected medicines, with higher values indicating a more effective treatment combination. The optimization process ensures that this goal is achieved while respecting the constraints on adverse interactions, the number of medicines, and FDA approval status.

## 2. Constraints  

The selection of medicines for the clinical trial is subject to the following constraints:  
1. **Adverse Interaction Limit**: The total adverse interaction score of all selected medicines must not exceed the maximum allowed value of 0.5. This ensures that the combined risk of the selected medicines remains within safe limits.  
2. **Medicine Count Limit**: The total number of medicines selected for the trial must not exceed the maximum allowed value of 3. This constraint helps manage the complexity and resource requirements of the trial.  
3. **FDA Approval Requirement**: Only medicines that are FDA-approved can be selected for the trial. This ensures that all included medicines meet regulatory standards for safety and efficacy.  

These constraints ensure that the selected combination of medicines is both effective and safe, while also being practical to implement in a clinical trial setting.

## 3. Available Data  

### Database Schema  
```sql
-- Iteration 3 Database Schema
-- Objective: Schema changes include adding missing scalar parameters to business configuration logic and ensuring all optimization mappings are complete. No table modifications or deletions were necessary.

CREATE TABLE medicine_effectiveness (
  medicine_id INTEGER,
  effectiveness_score FLOAT
);

CREATE TABLE medicine_adverse_interaction (
  medicine_id INTEGER,
  adverse_interaction_score FLOAT
);

CREATE TABLE medicine (
  medicine_id INTEGER,
  FDA_approved BOOLEAN
);

CREATE TABLE medicine_selection (
  medicine_id INTEGER,
  is_selected BOOLEAN
);
```

### Data Dictionary  
- **medicine_effectiveness**:  
  - **Purpose**: Stores the effectiveness scores of medicines based on enzyme interactions.  
  - **Columns**:  
    - `medicine_id`: Unique identifier for each medicine.  
    - `effectiveness_score`: Quantifies the potential benefit of the medicine.  

- **medicine_adverse_interaction**:  
  - **Purpose**: Stores the adverse interaction scores of medicines based on enzyme interactions.  
  - **Columns**:  
    - `medicine_id`: Unique identifier for each medicine.  
    - `adverse_interaction_score`: Measures the potential risk of the medicine when combined with others.  

- **medicine**:  
  - **Purpose**: Lists all medicines along with their FDA approval status.  
  - **Columns**:  
    - `medicine_id`: Unique identifier for each medicine.  
    - `FDA_approved`: Indicates whether the medicine is approved by the FDA.  

- **medicine_selection**:  
  - **Purpose**: Tracks the selection status of each medicine for the clinical trial.  
  - **Columns**:  
    - `medicine_id`: Unique identifier for each medicine.  
    - `is_selected`: Indicates whether the medicine has been selected for the trial.  

### Current Stored Values  
```sql
-- Iteration 3 Realistic Data
-- Generated by triple expert (business + data + optimization)
-- Values were determined based on realistic pharmaceutical data, ensuring effectiveness scores and adverse interaction scores are within plausible ranges. The number of medicines and their FDA approval statuses were chosen to reflect a typical clinical trial scenario.

-- Realistic data for medicine_effectiveness
INSERT INTO medicine_effectiveness (medicine_id, effectiveness_score) VALUES (1, 0.85);
INSERT INTO medicine_effectiveness (medicine_id, effectiveness_score) VALUES (2, 0.75);
INSERT INTO medicine_effectiveness (medicine_id, effectiveness_score) VALUES (3, 0.9);

-- Realistic data for medicine_adverse_interaction
INSERT INTO medicine_adverse_interaction (medicine_id, adverse_interaction_score) VALUES (1, 0.15);
INSERT INTO medicine_adverse_interaction (medicine_id, adverse_interaction_score) VALUES (2, 0.25);
INSERT INTO medicine_adverse_interaction (medicine_id, adverse_interaction_score) VALUES (3, 0.1);

-- Realistic data for medicine
INSERT INTO medicine (medicine_id, FDA_approved) VALUES (1, True);
INSERT INTO medicine (medicine_id, FDA_approved) VALUES (2, False);
INSERT INTO medicine (medicine_id, FDA_approved) VALUES (3, True);

-- Realistic data for medicine_selection
INSERT INTO medicine_selection (medicine_id, is_selected) VALUES (1, False);
INSERT INTO medicine_selection (medicine_id, is_selected) VALUES (2, False);
INSERT INTO medicine_selection (medicine_id, is_selected) VALUES (3, False);
```