# Complete Optimization Problem and Solution: movie_1

## 1. Problem Context and Goals

### Context  
A movie streaming platform is focused on enhancing viewer satisfaction by strategically recommending movies based on user ratings. The platform must decide how many times each movie should be recommended to each reviewer to maximize overall satisfaction. The satisfaction is measured by the sum of star ratings associated with the recommendations. 

The platform operates under specific operational constraints:  
1. Each movie has a maximum number of times it can be recommended across all reviewers.  
2. Each reviewer has a maximum number of recommendations they can receive in total.  
3. Recommendations must be non-negative and integer-valued.  

The star ratings provided by reviewers for movies serve as the key metric for determining the value of each recommendation. The platform’s goal is to allocate recommendations in a way that maximizes the total satisfaction while respecting these operational limits.  

### Goals  
The primary goal of this optimization problem is to maximize the total satisfaction derived from movie recommendations. This is achieved by strategically assigning the number of times each movie is recommended to each reviewer, weighted by the star ratings provided by the reviewers. Success is measured by the total sum of star ratings across all recommendations, ensuring that the platform’s operational constraints are fully respected.  

## 2. Constraints  

The optimization problem is subject to the following constraints:  
1. **Movie Recommendation Limits**: The total number of times a movie is recommended across all reviewers must not exceed the maximum allowed for that movie.  
2. **Reviewer Recommendation Limits**: The total number of recommendations received by a reviewer must not exceed the maximum allowed for that reviewer.  
3. **Non-Negative Recommendations**: The number of times a movie is recommended to a reviewer must be a non-negative integer.  

These constraints ensure that the platform’s operational limits are respected while maximizing viewer satisfaction.  

## 3. Available Data  

### Database Schema  
```sql
-- Iteration 2 Database Schema
-- Objective: Added a new table for star ratings to address missing objective coefficients, updated business configuration logic, and ensured all mappings are complete.

CREATE TABLE MovieRecommendationLimits (
  movie_id INTEGER,
  max_recommendations INTEGER
);

CREATE TABLE ReviewerRecommendationLimits (
  reviewer_id INTEGER,
  max_recommendations INTEGER
);

CREATE TABLE RecommendationAssignments (
  reviewer_id INTEGER,
  movie_id INTEGER,
  recommendation_count INTEGER
);

CREATE TABLE MovieRatings (
  reviewer_id INTEGER,
  movie_id INTEGER,
  star_rating INTEGER
);
```

### Data Dictionary  
- **MovieRecommendationLimits**:  
  - **Purpose**: Defines the maximum number of recommendations allowed for each movie.  
  - **Columns**:  
    - `movie_id`: Unique identifier for the movie.  
    - `max_recommendations`: Maximum number of recommendations allowed for the movie.  

- **ReviewerRecommendationLimits**:  
  - **Purpose**: Defines the maximum number of recommendations allowed for each reviewer.  
  - **Columns**:  
    - `reviewer_id`: Unique identifier for the reviewer.  
    - `max_recommendations`: Maximum number of recommendations allowed for the reviewer.  

- **RecommendationAssignments**:  
  - **Purpose**: Tracks the number of times each movie is recommended to each reviewer.  
  - **Columns**:  
    - `reviewer_id`: Unique identifier for the reviewer receiving the recommendation.  
    - `movie_id`: Unique identifier for the movie being recommended.  
    - `recommendation_count`: Number of times the movie is recommended to the reviewer.  

- **MovieRatings**:  
  - **Purpose**: Stores the star ratings given by reviewers to movies.  
  - **Columns**:  
    - `reviewer_id`: Unique identifier for the reviewer providing the rating.  
    - `movie_id`: Unique identifier for the movie being rated.  
    - `star_rating`: Star rating given by the reviewer to the movie.  

### Current Stored Values  
```sql
-- Iteration 2 Realistic Data
-- Generated by triple expert (business + data + optimization)
-- Values were determined based on realistic business scenarios, ensuring that the optimization problem remains meaningful and solvable. Constraints were respected, and relationships between tables were maintained to ensure consistency.

-- Realistic data for MovieRecommendationLimits
INSERT INTO MovieRecommendationLimits (movie_id, max_recommendations) VALUES (1, 10);
INSERT INTO MovieRecommendationLimits (movie_id, max_recommendations) VALUES (2, 7);
INSERT INTO MovieRecommendationLimits (movie_id, max_recommendations) VALUES (3, 5);

-- Realistic data for ReviewerRecommendationLimits
INSERT INTO ReviewerRecommendationLimits (reviewer_id, max_recommendations) VALUES (1, 5);
INSERT INTO ReviewerRecommendationLimits (reviewer_id, max_recommendations) VALUES (2, 4);
INSERT INTO ReviewerRecommendationLimits (reviewer_id, max_recommendations) VALUES (3, 3);

-- Realistic data for RecommendationAssignments
INSERT INTO RecommendationAssignments (reviewer_id, movie_id, recommendation_count) VALUES (1, 1, 2);
INSERT INTO RecommendationAssignments (reviewer_id, movie_id, recommendation_count) VALUES (2, 2, 1);
INSERT INTO RecommendationAssignments (reviewer_id, movie_id, recommendation_count) VALUES (3, 3, 1);

-- Realistic data for MovieRatings
INSERT INTO MovieRatings (reviewer_id, movie_id, star_rating) VALUES (1, 1, 5);
INSERT INTO MovieRatings (reviewer_id, movie_id, star_rating) VALUES (2, 2, 4);
INSERT INTO MovieRatings (reviewer_id, movie_id, star_rating) VALUES (3, 3, 3);
```