# Complete Optimization Problem and Solution: museum_visit

## 1. Problem Context and Goals

### Context  
A museum chain is focused on maximizing its total revenue from ticket sales across all its locations. The key decision involves determining the optimal number of tickets to sell at each museum. This decision must consider two critical operational constraints:  
1. **Ticket Sales Limit**: Each museum has a maximum number of tickets it can sell, ensuring that ticket sales do not exceed the museum's capacity.  
2. **Staff Availability**: Each museum has a maximum number of visitors that its staff can effectively manage, ensuring a safe and enjoyable experience for all guests.  

The business configuration includes:  
- **Total_Ticket_Limit**: The maximum number of tickets that can be sold at each museum, which serves as an upper bound for ticket sales.  
- **Staff_Capacity**: The maximum number of visitors that can be handled by the staff at each museum, which also serves as an upper bound for ticket sales based on staff availability.  

The goal is to make decisions that align with these constraints while maximizing revenue. The revenue generated at each museum is directly proportional to the number of tickets sold, ensuring a linear relationship between the decision variables and the objective.  

### Goals  
The primary optimization goal is to maximize the total revenue generated from ticket sales across all museums. This is achieved by determining the optimal number of tickets to sell at each museum, considering the constraints on ticket sales and staff availability. Success is measured by the total revenue, which is calculated as the sum of the revenue generated at each museum. The revenue at each museum is determined by multiplying the number of tickets sold by the revenue per ticket, ensuring a straightforward and linear relationship.  

## 2. Constraints  

The optimization problem is subject to the following constraints:  
1. **Ticket Sales Limit**: The number of tickets sold at each museum cannot exceed the maximum number of tickets that the museum is allowed to sell. This ensures that ticket sales remain within the museum's capacity.  
2. **Staff Availability**: The number of tickets sold at each museum cannot exceed the maximum number of visitors that the museum's staff can handle. This ensures that the staff can effectively manage the number of visitors, maintaining a safe and enjoyable environment.  

These constraints are designed to ensure that the optimization problem remains linear, with no variable products or divisions involved.  

## 3. Available Data  

### Database Schema  
```sql
-- Iteration 1 Database Schema
-- Objective: Schema changes include creating tables for missing constraints (Total_Ticket_Limit and Staff_Capacity) and updating business configuration logic for scalar parameters and formulas.

CREATE TABLE museum_constraints (
  Museum_ID INTEGER,
  Total_Ticket_Limit INTEGER,
  Staff_Capacity INTEGER
);

CREATE TABLE visit (
  Museum_ID INTEGER,
  Num_of_Ticket INTEGER,
  Total_spent FLOAT
);
```

### Data Dictionary  
- **museum_constraints**: This table contains the maximum ticket limits and staff capacity for each museum.  
  - **Museum_ID**: A unique identifier for each museum.  
  - **Total_Ticket_Limit**: The maximum number of tickets that can be sold at each museum.  
  - **Staff_Capacity**: The maximum number of visitors that can be handled by the staff at each museum.  

- **visit**: This table contains the revenue generated from ticket sales at each museum.  
  - **Museum_ID**: A unique identifier for each museum.  
  - **Num_of_Ticket**: The number of tickets sold at each museum.  
  - **Total_spent**: The revenue generated from ticket sales at each museum.  

### Current Stored Values  
```sql
-- Iteration 1 Realistic Data
-- Generated by triple expert (business + data + optimization)
-- Values were determined based on typical museum capacities, staff-to-visitor ratios, and ticket pricing strategies to ensure realistic and meaningful optimization.

-- Realistic data for museum_constraints
INSERT INTO museum_constraints (Museum_ID, Total_Ticket_Limit, Staff_Capacity) VALUES (1, 1200, 600);
INSERT INTO museum_constraints (Museum_ID, Total_Ticket_Limit, Staff_Capacity) VALUES (2, 1500, 750);
INSERT INTO museum_constraints (Museum_ID, Total_Ticket_Limit, Staff_Capacity) VALUES (3, 1000, 500);

-- Realistic data for visit
INSERT INTO visit (Museum_ID, Num_of_Ticket, Total_spent) VALUES (1, 500, 2500.0);
INSERT INTO visit (Museum_ID, Num_of_Ticket, Total_spent) VALUES (2, 700, 3500.0);
INSERT INTO visit (Museum_ID, Num_of_Ticket, Total_spent) VALUES (3, 300, 1500.0);
```