# Complete Optimization Problem and Solution: music_4

## 1. Problem Context and Goals

### Context  
A music festival organizer is tasked with curating a lineup of songs that maximizes the total number of weeks these songs have spent on top charts. The organizer must make binary decisions for each song, determining whether it is included in the festival lineup. The primary operational parameter driving this decision is the number of weeks each song has been on top charts, which directly contributes to the festival's overall success metric.  

To ensure a balanced and diverse festival, the organizer must adhere to several business configuration parameters:  
- The festival can include a maximum of 50 songs, ensuring the lineup remains manageable and focused.  
- No single artist can have more than 3 songs in the festival, promoting diversity and preventing overrepresentation of any one artist.  
- The festival must feature at least 10 unique artists, guaranteeing a broad representation of musical talent.  

These constraints are designed to align with realistic operational limitations while maintaining the festival's appeal and manageability. The decision-making process is linear, focusing solely on selecting songs based on their chart performance and ensuring compliance with the established constraints.  

### Goals  
The primary goal of this optimization problem is to maximize the total number of weeks that the selected songs have spent on top charts. This is achieved by summing the weeks on top for each song included in the festival lineup. Success is measured by the cumulative chart performance of the selected songs, ensuring the festival features the most impactful and popular tracks.  

The optimization process is designed to be straightforward and linear, avoiding complex relationships such as variable products or divisions. The focus is on making clear, binary decisions for each song while adhering to the festival's operational constraints.  

## 2. Constraints  

The optimization problem is subject to the following constraints, which ensure the festival lineup is both high-performing and diverse:  
1. **Total Song Capacity**: The total number of songs selected for the festival cannot exceed 50. This ensures the lineup remains manageable and aligns with the festival's capacity.  
2. **Maximum Songs Per Artist**: No single artist can have more than 3 songs included in the festival. This promotes diversity and prevents any one artist from dominating the lineup.  
3. **Minimum Number of Artists**: The festival must feature at least 10 unique artists. This guarantees a broad representation of musical talent and enhances the festival's appeal.  

These constraints are designed to be linear and straightforward, ensuring the optimization problem remains computationally efficient and aligned with the festival's operational goals.  

## 3. Available Data  

### Database Schema  
```sql
-- Iteration 1 Database Schema
-- Objective: Schema changes include creating new tables for decision variables and constraint bounds, and updating business configuration logic for scalar parameters and formulas.

CREATE TABLE song_selection (
  x_song BOOLEAN
);

CREATE TABLE volume (
  Weeks_on_Top INTEGER
);
```

### Data Dictionary  
- **song_selection**:  
  - **Business Purpose**: This table contains binary decision variables indicating whether a song is selected for the festival.  
  - **Optimization Role**: Decision variables in the optimization formulation.  
  - **Columns**:  
    - **x_song**: A binary variable (0 or 1) representing whether a song is included in the festival lineup.  

- **volume**:  
  - **Business Purpose**: This table tracks the number of weeks each song has spent on top charts.  
  - **Optimization Role**: Provides coefficients for the objective function.  
  - **Columns**:  
    - **Weeks_on_Top**: The number of weeks a song has been on top charts, used to measure its impact and popularity.  

### Current Stored Values  
```sql
-- Iteration 1 Realistic Data
-- Generated by triple expert (business + data + optimization)
-- Values were determined based on realistic music festival scenarios, ensuring diversity in artists and adherence to budget constraints while maximizing chart performance.

-- Realistic data for song_selection
INSERT INTO song_selection (x_song) VALUES (0);
INSERT INTO song_selection (x_song) VALUES (1);
INSERT INTO song_selection (x_song) VALUES (1);

-- Realistic data for volume
INSERT INTO volume (Weeks_on_Top) VALUES (5);
INSERT INTO volume (Weeks_on_Top) VALUES (10);
INSERT INTO volume (Weeks_on_Top) VALUES (15);
INSERT INTO volume (Weeks_on_Top) VALUES (3);
INSERT INTO volume (Weeks_on_Top) VALUES (8);
```