# Complete Optimization Problem and Solution: network_1

## 1. Problem Context and Goals

### Context  
A high school is focused on enhancing student well-being by strategically pairing students as friends based on mutual likes. The goal is to maximize overall student happiness while ensuring a balanced social environment. Each student must have a minimum number of friends to prevent isolation and a maximum number to avoid overwhelming social commitments. The decision to pair two students as friends is represented as a binary choice, where a value of 1 indicates a friendship and 0 indicates no friendship. The happiness score between two students, derived from mutual likes, serves as the basis for measuring the success of these pairings. The school has established operational parameters to guide this process: each student must have at least 2 friends and no more than 5 friends. These parameters ensure a supportive yet manageable social network for all students.

### Goals  
The primary goal of this optimization effort is to maximize the total happiness score across all student pairings. This is achieved by strategically selecting friendships that contribute the most to overall happiness, as measured by the happiness scores between students. Success is determined by the sum of happiness scores from all paired friendships, ensuring that the chosen pairings align with the school’s objective of fostering a positive and balanced social environment.

## 2. Constraints  

1. **Minimum Friends Constraint**: Every student must have at least 2 friends. This ensures that no student is left isolated and that everyone has a supportive social network.  
2. **Maximum Friends Constraint**: No student can have more than 5 friends. This prevents any student from being overwhelmed by too many social commitments, promoting a balanced social environment.  
3. **Mutual Friendship Constraint**: If a student is paired with a friend, the friend must also be paired with the student. This ensures that all friendships are mutual and reflect genuine social connections.  

These constraints are designed to maintain fairness and balance in the student pairing process while aligning with the school’s operational parameters.

## 3. Available Data  

### Database Schema  
```sql
-- Iteration 1 Database Schema
-- Objective: Schema changes include creating a HappinessScore table to map likes between students, and moving max_friends and min_friends to business_configuration_logic.json. The Friend table is modified to ensure mutual friendships.

CREATE TABLE HappinessScore (
  student_id INTEGER,
  friend_id INTEGER,
  score INTEGER
);

CREATE TABLE Friend (
  student_id INTEGER,
  friend_id INTEGER
);
```

### Data Dictionary  
- **HappinessScore Table**:  
  - **Purpose**: Maps happiness scores between student pairs based on mutual likes.  
  - **Columns**:  
    - `student_id`: Identifies the student in the happiness score pair.  
    - `friend_id`: Identifies the friend in the happiness score pair.  
    - `score`: Represents the happiness score (1 if the student likes the friend, otherwise 0). This score is used as the coefficient in the optimization objective.  

- **Friend Table**:  
  - **Purpose**: Represents mutual friendships between students.  
  - **Columns**:  
    - `student_id`: Identifies the student in the friendship pair.  
    - `friend_id`: Identifies the friend in the friendship pair.  

### Current Stored Values  
```sql
-- Iteration 1 Realistic Data
-- Generated by triple expert (business + data + optimization)
-- Values were determined based on realistic high school scenarios, ensuring each student has a balanced number of friends and mutual likes are represented. The happiness scores reflect mutual interests, and the number of friends per student adheres to the configured constraints.

-- Realistic data for HappinessScore
INSERT INTO HappinessScore (student_id, friend_id, score) VALUES (1, 2, 1);
INSERT INTO HappinessScore (student_id, friend_id, score) VALUES (2, 3, 1);
INSERT INTO HappinessScore (student_id, friend_id, score) VALUES (3, 1, 1);
INSERT INTO HappinessScore (student_id, friend_id, score) VALUES (1, 3, 0);
INSERT INTO HappinessScore (student_id, friend_id, score) VALUES (2, 1, 0);

-- Realistic data for Friend
INSERT INTO Friend (student_id, friend_id) VALUES (1, 2);
INSERT INTO Friend (student_id, friend_id) VALUES (2, 3);
INSERT INTO Friend (student_id, friend_id) VALUES (3, 1);
```