# Complete Optimization Problem and Solution: network_2

## 1. Problem Context and Goals

### Context  
The social network aims to maximize the number of friendships formed among its users while ensuring a balanced and inclusive network. Each user can form friendships with others, but the network enforces specific rules to maintain balance and prevent overloading any single user. 

Key operational parameters include:  
- **Maximum number of friendships per person**: Each user is allowed to have up to 15 friendships. This ensures that no single user is overwhelmed with too many connections.  
- **Minimum number of friendships per age group**: Each user must have at least 3 friendships with users from different age groups. This promotes diversity and inclusivity across the network.  

The network also ensures that friendships are mutual, meaning if person i is friends with person j, then person j must also be friends with person i. This mutual relationship is a fundamental requirement for all friendships in the network.  

The goal is to maximize the total number of friendships while adhering to these constraints, ensuring a balanced and sustainable social network.

### Goals  
The primary optimization goal is to maximize the total number of friendships formed across the network. Success is measured by the total count of friendships, ensuring that the network grows while maintaining balance and inclusivity.  

The network aims to achieve this by:  
- Encouraging as many friendships as possible within the allowed limits.  
- Ensuring that each user has a minimum number of friendships across different age groups.  
- Maintaining mutual friendships to foster genuine connections.  

This goal aligns with the operational parameters and ensures that the network remains diverse, inclusive, and scalable.

## 2. Constraints  

The optimization problem is subject to the following constraints:  
1. **Minimum friendships per age group**: Each user must have at least 3 friendships with users from each defined age group. This ensures that users have diverse connections across different age ranges.  
2. **Maximum friendships per person**: No user can have more than 15 friendships. This prevents any single user from being overwhelmed with too many connections.  
3. **Mutual friendships**: If person i is friends with person j, then person j must also be friends with person i. This ensures that all friendships are mutual and genuine.  

These constraints ensure that the network remains balanced, inclusive, and sustainable while maximizing the total number of friendships.

## 3. Available Data  

### Database Schema  
```sql
-- Iteration 1 Database Schema
-- Objective: Schema changes include creating tables for decision variables, age groups, and friendships. Configuration logic updates include scalar parameters for max friendships per person and min friendships per age group, and a formula for friendship balance.

CREATE TABLE friendships (
  person_i INTEGER,
  person_j INTEGER,
  is_friends BOOLEAN
);

CREATE TABLE age_groups (
  age_group_id INTEGER,
  age_range STRING
);
```

### Data Dictionary  
- **Friendships Table**:  
  - **Purpose**: Tracks whether a friendship exists between two users.  
  - **Columns**:  
    - `person_i`: The ID of the first user in the friendship.  
    - `person_j`: The ID of the second user in the friendship.  
    - `is_friends`: Indicates whether the two users are friends (True or False).  

- **Age Groups Table**:  
  - **Purpose**: Defines the age groups used to ensure balanced friendships across different age ranges.  
  - **Columns**:  
    - `age_group_id`: The ID of the age group.  
    - `age_range`: The age range for the group (e.g., 18-25, 26-35).  

### Current Stored Values  
```sql
-- Iteration 1 Realistic Data
-- Generated by triple expert (business + data + optimization)
-- Values were determined based on realistic social network scenarios, ensuring diversity in age groups and balanced friendships while respecting constraints.

-- Realistic data for friendships
INSERT INTO friendships (person_i, person_j, is_friends) VALUES (1, 2, True);
INSERT INTO friendships (person_i, person_j, is_friends) VALUES (1, 3, False);
INSERT INTO friendships (person_i, person_j, is_friends) VALUES (2, 3, True);
INSERT INTO friendships (person_i, person_j, is_friends) VALUES (3, 4, True);
INSERT INTO friendships (person_i, person_j, is_friends) VALUES (4, 5, False);

-- Realistic data for age_groups
INSERT INTO age_groups (age_group_id, age_range) VALUES (1, 18-25);
INSERT INTO age_groups (age_group_id, age_range) VALUES (2, 26-35);
INSERT INTO age_groups (age_group_id, age_range) VALUES (3, 36-45);
```