# Complete Optimization Problem and Solution: news_report

## 1. Problem Context and Goals

### Context  
A news agency is tasked with optimizing the assignment of journalists to events to maximize the overall quality of coverage. The quality of coverage is determined by the journalist's years of experience and the attendance of the event they are assigned to. Each event must be covered by at least one journalist, and no journalist can be assigned to more than a specified number of events, as defined by the business configuration. The decision to assign a journalist to an event is represented as a binary choice, ensuring a clear and linear relationship between the decision variables and the objective. The coverage quality is calculated as the product of the journalist's years of experience and the event's attendance, which directly contributes to the linear objective function. This setup ensures that the optimization problem remains linear, avoiding any nonlinear relationships such as variable products or divisions.

### Goals  
The primary goal of this optimization problem is to maximize the total coverage quality across all events. This is achieved by strategically assigning journalists to events in a way that leverages their experience and the significance of the event, as measured by attendance. Success is measured by the sum of the coverage quality scores for all assignments, where each score is the product of the journalist's years of experience and the event's attendance. The optimization process ensures that the assignments are made within the constraints of each journalist's maximum allowable number of event assignments, maintaining a balanced and efficient allocation of resources.

## 2. Constraints    

1. **Event Coverage Requirement**: Each event must be covered by at least one journalist. This ensures that all events receive adequate coverage, and no event is left unattended.  
2. **Journalist Assignment Limit**: No journalist can be assigned to more than the maximum number of events specified in the business configuration. This prevents overburdening journalists and ensures a fair distribution of assignments.  

These constraints are designed to maintain operational feasibility while aligning with the linear structure of the optimization problem. They ensure that the assignments are both comprehensive and balanced, without introducing any nonlinear complexities.

## 3. Available Data  

### Database Schema  
```sql
-- Iteration 1 Database Schema
-- Objective: Schema changes include creating a new table for journalist-event assignments and adding a column for maximum assignments per journalist. Configuration logic updates include adding scalar parameters for maximum assignments and a formula for coverage quality calculation.

CREATE TABLE journalist (
  Years_working INTEGER,
  max_assignments INTEGER
);

CREATE TABLE event (
  Event_Attendance INTEGER
);

CREATE TABLE journalist_event_assignment (
  assignment BOOLEAN
);
```

### Data Dictionary  
- **Journalist Table**:  
  - **Years_working**: Represents the number of years a journalist has been working. This value is used to calculate the coverage quality score.  
  - **max_assignments**: Specifies the maximum number of events a journalist can be assigned to, ensuring balanced workloads.  

- **Event Table**:  
  - **Event_Attendance**: Represents the number of attendees at an event. This value is used to calculate the coverage quality score.  

- **Journalist_Event_Assignment Table**:  
  - **assignment**: A binary indicator (0 or 1) that determines whether a journalist is assigned to a specific event. This is the decision variable in the optimization problem.  

### Current Stored Values  
```sql
-- Iteration 1 Realistic Data
-- Generated by triple expert (business + data + optimization)
-- Values were determined based on realistic business scenarios, considering journalist experience levels, event attendance ranges, and assignment constraints to ensure a meaningful and solvable optimization problem.

-- Realistic data for journalist
INSERT INTO journalist (Years_working, max_assignments) VALUES (5, 3);
INSERT INTO journalist (Years_working, max_assignments) VALUES (10, 4);
INSERT INTO journalist (Years_working, max_assignments) VALUES (15, 5);

-- Realistic data for event
INSERT INTO event (Event_Attendance) VALUES (100);
INSERT INTO event (Event_Attendance) VALUES (200);
INSERT INTO event (Event_Attendance) VALUES (300);

-- Realistic data for journalist_event_assignment
INSERT INTO journalist_event_assignment (assignment) VALUES (0);
INSERT INTO journalist_event_assignment (assignment) VALUES (1);
INSERT INTO journalist_event_assignment (assignment) VALUES (0);
```