# Complete Optimization Problem and Solution: orchestra

## 1. Problem Context and Goals

### Context  
An orchestra management company is tasked with maximizing the total attendance across all performances by optimizing the number of shows each orchestra conducts. The decision revolves around determining the ideal number of performances for each orchestra, ensuring that the total attendance is as high as possible. This decision must consider several operational constraints, including the availability of conductors, the minimum number of performances required for each orchestra to maintain its reputation, and the maximum number of performances each orchestra can feasibly handle. The attendance per performance for each orchestra is a key factor in this decision, as it directly influences the total attendance. The company aims to make these decisions in a way that is both efficient and feasible, ensuring that all constraints are respected while achieving the highest possible attendance.

### Goals  
The primary goal of this optimization problem is to maximize the total attendance across all performances. This is achieved by determining the optimal number of performances for each orchestra, taking into account the attendance per performance for each orchestra. Success is measured by the total attendance figure, which is the sum of the attendance for each performance across all orchestras. The company aims to make decisions that lead to the highest possible total attendance while adhering to all operational constraints.

## 2. Constraints    

The optimization problem must adhere to the following constraints:

1. **Conductor Availability**: The total number of performances across all orchestras must not exceed the total availability of each conductor. This ensures that conductors are not overburdened and can effectively manage their schedules.

2. **Minimum Performances**: Each orchestra must conduct at least a minimum number of performances. This constraint ensures that each orchestra maintains its reputation and meets its contractual obligations.

3. **Maximum Performances**: Each orchestra cannot conduct more than a maximum number of performances. This constraint ensures that orchestras do not overextend themselves and can maintain the quality of their performances.

These constraints are designed to ensure that the optimization problem remains feasible and that all operational limitations are respected.

## 3. Available Data  

### Database Schema  
```sql
-- Iteration 2 Database Schema
-- Objective: Added attendance table to map attendance data per performance for each orchestra, ensuring the objective function is complete. No tables were deleted or modified as existing tables adequately map to the optimization requirements.

CREATE TABLE attendance (
  Orchestra_ID INTEGER,
  Attendance INTEGER
);

CREATE TABLE conductor_availability (
  Conductor_ID INTEGER,
  Total_Availability INTEGER
);

CREATE TABLE performance_ratings (
  Performance_ID INTEGER,
  Minimum_Rating FLOAT
);

CREATE TABLE performance_limits (
  Orchestra_ID INTEGER,
  Maximum_Performances INTEGER,
  Minimum_Performances INTEGER,
  Number_of_Performances INTEGER
);
```

### Data Dictionary  
- **attendance**: This table contains data on the attendance per performance for each orchestra. The `Orchestra_ID` column uniquely identifies each orchestra, while the `Attendance` column records the number of attendees per performance. This data is crucial for determining the total attendance, which is the primary metric to optimize.

- **conductor_availability**: This table records the total availability of each conductor. The `Conductor_ID` column uniquely identifies each conductor, and the `Total_Availability` column indicates the total number of hours each conductor is available. This data is used to ensure that the total number of performances does not exceed the conductors' availability.

- **performance_ratings**: This table contains the minimum required rating for each performance. The `Performance_ID` column uniquely identifies each performance, and the `Minimum_Rating` column specifies the minimum rating required for each performance. This data ensures that the quality of performances is maintained.

- **performance_limits**: This table defines the maximum and minimum number of performances allowed for each orchestra. The `Orchestra_ID` column uniquely identifies each orchestra, while the `Maximum_Performances` and `Minimum_Performances` columns specify the upper and lower limits on the number of performances. The `Number_of_Performances` column is used as a decision variable in the optimization problem, representing the number of performances each orchestra should conduct.

### Current Stored Values  
```sql
-- Iteration 2 Realistic Data
-- Generated by triple expert (business + data + optimization)
-- Values were determined based on realistic business scenarios, considering typical orchestra sizes, conductor availability, and performance constraints. Attendance figures were derived from average concert hall capacities, and performance limits were set to ensure feasibility while maximizing attendance.

-- Realistic data for attendance
INSERT INTO attendance (Orchestra_ID, Attendance) VALUES (1, 500);
INSERT INTO attendance (Orchestra_ID, Attendance) VALUES (2, 600);
INSERT INTO attendance (Orchestra_ID, Attendance) VALUES (3, 450);

-- Realistic data for conductor_availability
INSERT INTO conductor_availability (Conductor_ID, Total_Availability) VALUES (1, 100);
INSERT INTO conductor_availability (Conductor_ID, Total_Availability) VALUES (2, 120);
INSERT INTO conductor_availability (Conductor_ID, Total_Availability) VALUES (3, 80);

-- Realistic data for performance_ratings
INSERT INTO performance_ratings (Performance_ID, Minimum_Rating) VALUES (1, 5.0);
INSERT INTO performance_ratings (Performance_ID, Minimum_Rating) VALUES (2, 6.0);
INSERT INTO performance_ratings (Performance_ID, Minimum_Rating) VALUES (3, 4.5);

-- Realistic data for performance_limits
INSERT INTO performance_limits (Orchestra_ID, Maximum_Performances, Minimum_Performances, Number_of_Performances) VALUES (1, 10, 1, 5);
INSERT INTO performance_limits (Orchestra_ID, Maximum_Performances, Minimum_Performances, Number_of_Performances) VALUES (2, 12, 2, 6);
INSERT INTO performance_limits (Orchestra_ID, Maximum_Performances, Minimum_Performances, Number_of_Performances) VALUES (3, 8, 1, 4);
```