# Complete Optimization Problem and Solution: perpetrator

## 1. Problem Context and Goals

### Context  
A security agency is tasked with minimizing the total number of casualties (both killed and injured) across various locations by strategically allocating its limited resources. The agency must decide how many resources to assign to each location to effectively monitor and prevent incidents. Historical data indicates that the allocation of resources directly impacts the reduction of casualties in each location. The agency operates under two critical operational constraints:  
1. The total number of resources available for allocation is fixed and cannot be exceeded.  
2. Each location has a maximum allowable number of casualties, which must not be surpassed.  

The agency’s decision-making process focuses on determining the optimal number of resources to allocate to each location, ensuring that the total resources used do not exceed the available capacity and that the casualties in each location remain within the predefined safety limits. This problem is inherently linear, as the relationships between resource allocation, casualties, and constraints are proportional and additive, without any nonlinear interactions such as variable products or divisions.

### Goals  
The primary goal of the agency is to minimize the total number of casualties across all locations. This is achieved by optimizing the allocation of resources to each location, ensuring that the sum of killed and injured individuals is as low as possible. Success is measured by the reduction in casualties, which is directly influenced by the effective distribution of resources. The agency aims to achieve this goal while adhering to the operational constraints of total resource availability and maximum allowable casualties per location.

## 2. Constraints  

The agency’s optimization problem is subject to the following constraints:  
1. **Total Resource Constraint**: The sum of resources allocated to all locations must not exceed the total number of resources available. This ensures that the agency does not overcommit its limited resources.  
2. **Maximum Casualties Constraint**: For each location, the sum of killed and injured individuals must not exceed the maximum allowed casualties. This ensures that safety thresholds are maintained in every location.  

These constraints are linear and proportional, ensuring that the optimization problem remains straightforward and solvable using linear methods.

## 3. Available Data  

### Database Schema  
```sql
-- Iteration 3 Database Schema
-- Objective: Added missing scalar parameters to business configuration logic, ensured schema follows normalization principles, and updated data dictionary to reflect changes.

CREATE TABLE ResourceAllocation (
  location_id INTEGER,
  resources_allocated FLOAT
);

CREATE TABLE Casualties (
  location_id INTEGER,
  killed INTEGER,
  injured INTEGER
);
```

### Data Dictionary  
- **ResourceAllocation Table**:  
  - **location_id**: A unique identifier for each location where resources are allocated.  
  - **resources_allocated**: The number of resources assigned to a specific location. This is the decision variable in the optimization problem.  

- **Casualties Table**:  
  - **location_id**: A unique identifier for each location where casualties are recorded.  
  - **killed**: The number of individuals killed in a specific location. This is a coefficient in the optimization objective.  
  - **injured**: The number of individuals injured in a specific location. This is a coefficient in the optimization objective.  

### Current Stored Values  
```sql
-- Iteration 3 Realistic Data
-- Generated by triple expert (business + data + optimization)
-- Values were determined based on historical data and realistic scenarios for a security agency, ensuring that the optimization problem remains meaningful and solvable.

-- Realistic data for ResourceAllocation
INSERT INTO ResourceAllocation (location_id, resources_allocated) VALUES (1, 20.0);
INSERT INTO ResourceAllocation (location_id, resources_allocated) VALUES (2, 15.0);
INSERT INTO ResourceAllocation (location_id, resources_allocated) VALUES (3, 10.0);

-- Realistic data for Casualties
INSERT INTO Casualties (location_id, killed, injured) VALUES (1, 5, 25);
INSERT INTO Casualties (location_id, killed, injured) VALUES (2, 3, 15);
INSERT INTO Casualties (location_id, killed, injured) VALUES (3, 1, 10);
```