# Complete Optimization Problem and Solution: phone_market

## 1. Problem Context and Goals

### Context  
A phone distributor is tasked with optimizing the allocation of phone stocks across various markets to maximize total revenue. The distributor must decide how many units of each phone model to allocate to each market, ensuring that the total stock allocated does not exceed the available stock for each phone model, the total stock in each market does not exceed its capacity, and the minimum stock requirements for each phone model in each market are met.  

The decision variables are the number of units of each phone model allocated to each market, represented as integers. The operational parameters include the price of each phone model, which serves as the coefficient in the objective function, and the maximum stock capacity for each market, which acts as a constraint bound for the total stock in each market. Additionally, the minimum stock requirements for each phone model in each market are used as constraint bounds to ensure adequate stock presence.  

The business configuration includes scalar parameters such as the maximum market capacity, which is set to 2000 units across all markets, and the minimum stock requirement, which is set to 50 units for each phone model in each market. These parameters ensure scalability and meet demand requirements.  

### Goals  
The primary goal of this optimization problem is to maximize the total revenue generated from the allocation of phone stocks across markets. This is achieved by determining the optimal number of units of each phone model to allocate to each market, considering the price of each phone model as the revenue driver. Success is measured by the total revenue calculated as the sum of the price of each phone model multiplied by the number of units allocated to each market.  

## 2. Constraints  

The optimization problem is subject to the following constraints:  
1. **Market Capacity Constraint**: The total number of units allocated to each market must not exceed the maximum stock capacity of that market. This ensures that the distributor does not overstock any market beyond its capacity.  
2. **Minimum Stock Requirement Constraint**: The number of units of each phone model allocated to each market must meet or exceed the minimum stock requirement for that phone model in that market. This ensures that each market has sufficient stock to meet demand.  

These constraints are designed to ensure that the allocation of phone stocks is both feasible and aligned with business requirements, without introducing any nonlinear relationships.  

## 3. Available Data  

### Database Schema  
```sql
-- Iteration 1 Database Schema
-- Objective: Schema changes include adding tables for maximum market capacities and minimum stock requirements, and updating business configuration logic to include scalar parameters and formulas for optimization constraints.

CREATE TABLE phone (
  Phone_ID INTEGER,
  Price FLOAT
);

CREATE TABLE market (
  Market_ID INTEGER,
  Num_of_shops INTEGER
);

CREATE TABLE phone_market (
  Market_ID INTEGER,
  Phone_ID INTEGER,
  Num_of_stock INTEGER
);

CREATE TABLE market_capacity (
  Market_ID INTEGER,
  Max_Capacity INTEGER
);

CREATE TABLE phone_min_stock (
  Market_ID INTEGER,
  Phone_ID INTEGER,
  Min_Stock INTEGER
);
```

### Data Dictionary  
- **phone**: Stores information about each phone model, including its unique identifier and price. The price is used as the coefficient in the objective function to calculate total revenue.  
- **market**: Stores information about each market, including its unique identifier and the number of shops. The maximum stock capacity for each market is derived from this table and used as a constraint bound.  
- **phone_market**: Stores the allocation of phone stocks across markets, including the number of units of each phone model allocated to each market. This table represents the decision variables in the optimization problem.  
- **market_capacity**: Stores the maximum stock capacity for each market, which is used as a constraint bound to ensure that the total stock allocated does not exceed the market's capacity.  
- **phone_min_stock**: Stores the minimum stock requirements for each phone model in each market, which is used as a constraint bound to ensure that each market has sufficient stock to meet demand.  

### Current Stored Values  
```sql
-- Iteration 1 Realistic Data
-- Generated by triple expert (business + data + optimization)
-- Values were determined based on realistic market capacities, phone prices, and stock requirements, ensuring that the optimization problem is meaningful and solvable.

-- Realistic data for phone
INSERT INTO phone (Phone_ID, Price) VALUES (1, 699.99);
INSERT INTO phone (Phone_ID, Price) VALUES (2, 899.99);
INSERT INTO phone (Phone_ID, Price) VALUES (3, 999.99);

-- Realistic data for market
INSERT INTO market (Market_ID, Num_of_shops) VALUES (1, 10);
INSERT INTO market (Market_ID, Num_of_shops) VALUES (2, 15);
INSERT INTO market (Market_ID, Num_of_shops) VALUES (3, 20);

-- Realistic data for phone_market
INSERT INTO phone_market (Market_ID, Phone_ID, Num_of_stock) VALUES (1, 1, 50);
INSERT INTO phone_market (Market_ID, Phone_ID, Num_of_stock) VALUES (2, 2, 100);
INSERT INTO phone_market (Market_ID, Phone_ID, Num_of_stock) VALUES (3, 3, 150);

-- Realistic data for market_capacity
INSERT INTO market_capacity (Market_ID, Max_Capacity) VALUES (1, 1000);
INSERT INTO market_capacity (Market_ID, Max_Capacity) VALUES (2, 1500);
INSERT INTO market_capacity (Market_ID, Max_Capacity) VALUES (3, 2000);

-- Realistic data for phone_min_stock
INSERT INTO phone_min_stock (Market_ID, Phone_ID, Min_Stock) VALUES (1, 1, 50);
INSERT INTO phone_min_stock (Market_ID, Phone_ID, Min_Stock) VALUES (2, 2, 100);
INSERT INTO phone_min_stock (Market_ID, Phone_ID, Min_Stock) VALUES (3, 3, 150);
```