# Complete Optimization Problem and Solution: product_catalog

## 1. Problem Context and Goals

### Context  
The company operates in a global market, selling products priced in three major currencies: US dollars, euros, and British pounds. To maximize revenue, the company needs to optimize the pricing of its products in each currency while ensuring prices remain within acceptable ranges and preventing arbitrage opportunities. Arbitrage could arise if price differences between currencies exceed a specified threshold, allowing customers to exploit discrepancies for profit.  

The company has established minimum and maximum price limits for each product in each currency to maintain competitiveness and profitability. Additionally, exchange rates between currencies are factored into the pricing strategy to ensure consistency across markets. The exchange rates currently in use are:  
- **Dollars to Euros**: 0.92  
- **Dollars to Pounds**: 0.79  
- **Euros to Pounds**: 0.86  

The maximum allowed price difference between currencies is set at $5.00 to prevent arbitrage. This ensures that prices in different currencies remain aligned after accounting for exchange rate fluctuations.  

The optimization problem focuses on adjusting product prices in dollars, euros, and pounds to maximize total revenue. Revenue is calculated as the sum of the product of each product's price in a currency and its expected sales volume in that currency. The decision variables are the prices in each currency, which can vary continuously within the defined bounds.  

### Goals  
The primary goal is to maximize total revenue across all products and currencies. Revenue is calculated by multiplying each product's price in dollars, euros, and pounds by its expected sales volume and summing these values across all products. Success is measured by achieving the highest possible revenue while adhering to the following constraints:  
1. Prices must remain within the specified minimum and maximum limits for each currency.  
2. Price differences between currencies, after applying exchange rates, must not exceed the maximum allowed difference of $5.00.  

This optimization ensures that the company's pricing strategy is both profitable and consistent across global markets, avoiding scenarios that could lead to arbitrage or customer dissatisfaction.  

## 2. Constraints  

The optimization problem is subject to the following constraints:  
1. **Price Bounds**:  
   - Each product's price in dollars must be between its minimum and maximum acceptable price in dollars.  
   - Each product's price in euros must be between its minimum and maximum acceptable price in euros.  
   - Each product's price in pounds must be between its minimum and maximum acceptable price in pounds.  

2. **Currency Price Differences**:  
   - The difference between a product's price in dollars converted to euros and its price in euros must not exceed the maximum allowed price difference of $5.00.  
   - The difference between a product's price in dollars converted to pounds and its price in pounds must not exceed the maximum allowed price difference of $5.00.  
   - The difference between a product's price in euros converted to pounds and its price in pounds must not exceed the maximum allowed price difference of $5.00.  

These constraints ensure that prices remain competitive, profitable, and consistent across currencies, preventing arbitrage opportunities.  

## 3. Available Data  

### Database Schema  
```sql
-- Iteration 1 Database Schema
-- Objective: Schema changes include creating new tables for sales volumes and price constraints, modifying the Catalog_Contents table to include foreign keys, and adding business configuration logic for exchange rates and maximum price differences.

CREATE TABLE Product_Sales_Volume (
  product_id INTEGER,
  sales_volume INTEGER
);

CREATE TABLE Product_Price_Constraints (
  product_id INTEGER,
  min_price_dollars FLOAT,
  max_price_dollars FLOAT,
  min_price_euros FLOAT,
  max_price_euros FLOAT,
  min_price_pounds FLOAT,
  max_price_pounds FLOAT
);

CREATE TABLE Catalog_Contents (
  product_id INTEGER,
  price_in_dollars FLOAT,
  price_in_euros FLOAT,
  price_in_pounds FLOAT
);
```

### Data Dictionary  
- **Product_Sales_Volume**:  
  - **Purpose**: Stores the expected sales volume for each product.  
  - **Optimization Role**: Provides coefficients for the revenue calculation in the objective function.  
  - **Columns**:  
    - `product_id`: Unique identifier for each product.  
    - `sales_volume`: Expected sales volume for the product.  

- **Product_Price_Constraints**:  
  - **Purpose**: Defines the minimum and maximum acceptable prices for each product in dollars, euros, and pounds.  
  - **Optimization Role**: Provides bounds for the price constraints.  
  - **Columns**:  
    - `product_id`: Unique identifier for each product.  
    - `min_price_dollars`: Minimum acceptable price in dollars.  
    - `max_price_dollars`: Maximum acceptable price in dollars.  
    - `min_price_euros`: Minimum acceptable price in euros.  
    - `max_price_euros`: Maximum acceptable price in euros.  
    - `min_price_pounds`: Minimum acceptable price in pounds.  
    - `max_price_pounds`: Maximum acceptable price in pounds.  

- **Catalog_Contents**:  
  - **Purpose**: Stores the current prices of products in dollars, euros, and pounds.  
  - **Optimization Role**: Contains the decision variables for the optimization problem.  
  - **Columns**:  
    - `product_id`: Unique identifier for each product.  
    - `price_in_dollars`: Price of the product in dollars.  
    - `price_in_euros`: Price of the product in euros.  
    - `price_in_pounds`: Price of the product in pounds.  

### Current Stored Values  
```sql
-- Iteration 1 Realistic Data
-- Generated by triple expert (business + data + optimization)
-- Values were determined based on realistic market conditions, historical exchange rates, and typical product pricing strategies. Sales volumes were estimated based on product popularity and market demand. Price constraints were set to reflect competitive pricing while allowing for profitability.

-- Realistic data for Product_Sales_Volume
INSERT INTO Product_Sales_Volume (product_id, sales_volume) VALUES (1, 150);
INSERT INTO Product_Sales_Volume (product_id, sales_volume) VALUES (2, 200);
INSERT INTO Product_Sales_Volume (product_id, sales_volume) VALUES (3, 100);

-- Realistic data for Product_Price_Constraints
INSERT INTO Product_Price_Constraints (product_id, min_price_dollars, max_price_dollars, min_price_euros, max_price_euros, min_price_pounds, max_price_pounds) VALUES (1, 10.0, 50.0, 9.0, 45.0, 8.0, 40.0);
INSERT INTO Product_Price_Constraints (product_id, min_price_dollars, max_price_dollars, min_price_euros, max_price_euros, min_price_pounds, max_price_pounds) VALUES (2, 15.0, 55.0, 14.0, 50.0, 13.0, 45.0);
INSERT INTO Product_Price_Constraints (product_id, min_price_dollars, max_price_dollars, min_price_euros, max_price_euros, min_price_pounds, max_price_pounds) VALUES (3, 20.0, 60.0, 19.0, 55.0, 18.0, 50.0);

-- Realistic data for Catalog_Contents
INSERT INTO Catalog_Contents (product_id, price_in_dollars, price_in_euros, price_in_pounds) VALUES (1, 25.0, 23.0, 20.0);
INSERT INTO Catalog_Contents (product_id, price_in_dollars, price_in_euros, price_in_pounds) VALUES (2, 30.0, 28.0, 25.0);
INSERT INTO Catalog_Contents (product_id, price_in_dollars, price_in_euros, price_in_pounds) VALUES (3, 35.0, 32.0, 30.0);
```