-- Iteration 2 Database Schema
-- Objective: Schema changes include creating tables for program shares and channel ratings to address missing optimization requirements. Configuration logic updates include scalar parameters for channel ratings and program shares.

CREATE TABLE time_slots (
  time_slot_id INTEGER,
  time_of_day STRING
);

CREATE TABLE program_origins (
  program_id INTEGER,
  origin STRING
);

CREATE TABLE broadcast_decisions (
  channel_id INTEGER,
  program_id INTEGER,
  time_slot_id INTEGER,
  x BOOLEAN
);

CREATE TABLE program_shares (
  channel_id INTEGER,
  program_id INTEGER,
  share_in_percent INTEGER
);

CREATE TABLE channel_ratings (
  channel_id INTEGER,
  rating_in_percent INTEGER
);

