# Complete Optimization Problem and Solution: restaurants

## 1. Problem Context and Goals

### Context  
A restaurant chain is strategically planning the placement of new restaurants across various cities to maximize overall customer satisfaction. Customer satisfaction is measured by the restaurant's rating, which serves as a key indicator of success. The decision to place a new restaurant in a specific city is represented by a binary choice: either to place the restaurant or not. The goal is to ensure that the total customer satisfaction across all new placements is maximized while adhering to several operational constraints.  

The business has established specific configuration parameters to guide this decision-making process:  
- **Maximum number of new restaurants allowed per city**: To prevent over-saturation, no more than 2 new restaurants can be placed in any single city.  
- **Minimum number of new restaurants required per region**: To maintain a balanced distribution, at least 1 new restaurant must be placed in each geographical region.  
- **Total budget constraint for the number of new restaurants**: The total number of new restaurants placed across all cities cannot exceed 5, ensuring financial feasibility.  

These parameters ensure that the optimization problem remains linear and avoids scenarios requiring complex nonlinear relationships, such as variable products or divisions.  

### Goals  
The primary goal of this optimization problem is to maximize the total customer satisfaction derived from the placement of new restaurants. This is achieved by selecting the optimal set of cities for new restaurant placements, where each placement contributes to the overall satisfaction based on the restaurant's rating. Success is measured by the sum of the ratings of all selected restaurants, ensuring that the highest possible customer satisfaction is achieved within the defined constraints.  

## 2. Constraints  

The optimization problem is subject to the following constraints, which ensure that the solution aligns with the business's operational and financial limitations:  
1. **Total budget constraint**: The total number of new restaurants placed across all cities must not exceed the budget of 5. This ensures that the financial resources are not overextended.  
2. **Regional distribution constraint**: Each geographical region must have at least 1 new restaurant placed. This ensures a fair and balanced distribution of new restaurants across all regions.  
3. **City-level placement constraint**: No more than 2 new restaurants can be placed in any single city. This prevents over-saturation and ensures a diverse placement strategy.  

These constraints are designed to naturally lead to linear mathematical forms, avoiding any complexity that would require nonlinear relationships.  

## 3. Available Data  

### Database Schema  
```sql
-- Iteration 1 Database Schema
-- Objective: Schema changes include creating new tables for decision variables and constraint bounds, moving scalar parameters to business configuration logic, and updating the data dictionary to reflect optimization mappings.

CREATE TABLE RESTAURANT (
  RATING FLOAT,
  REGION STRING
);

CREATE TABLE DECISION_VARIABLES (
  X_i BOOLEAN
);
```

### Data Dictionary  
- **RESTAURANT Table**:  
  - **RATING**: Represents the customer satisfaction rating of the restaurant. This value is used as the coefficient in the objective function to maximize total satisfaction.  
  - **REGION**: Indicates the geographical region where the restaurant is located. This supports the regional distribution constraint.  

- **DECISION_VARIABLES Table**:  
  - **X_i**: A binary decision variable that indicates whether to place a new restaurant in city i. This is the key variable in the optimization model.  

### Current Stored Values  
```sql
-- Iteration 1 Realistic Data
-- Generated by triple expert (business + data + optimization)
-- Values were determined based on realistic business scenarios, ensuring that the optimization problem remains meaningful and solvable. The data respects the constraints and relationships defined in the schema and business configuration logic.

-- Realistic data for RESTAURANT
INSERT INTO RESTAURANT (RATING, REGION) VALUES (4.5, 'North');
INSERT INTO RESTAURANT (RATING, REGION) VALUES (3.8, 'South');
INSERT INTO RESTAURANT (RATING, REGION) VALUES (4.2, 'East');
INSERT INTO RESTAURANT (RATING, REGION) VALUES (3.9, 'West');
INSERT INTO RESTAURANT (RATING, REGION) VALUES (4.1, 'North');

-- Realistic data for DECISION_VARIABLES
INSERT INTO DECISION_VARIABLES (X_i) VALUES (True);
INSERT INTO DECISION_VARIABLES (X_i) VALUES (False);
INSERT INTO DECISION_VARIABLES (X_i) VALUES (True);
```