# Complete Optimization Problem and Solution: scientist_1

## 1. Problem Context and Goals

### Context  
A research institute is tasked with efficiently assigning scientists to projects to optimize resource utilization. The primary business decision involves determining whether a scientist is assigned to a specific project, represented as a binary choice. The operational parameters include the hours required for each project, which are used to calculate the total project hours. The goal is to minimize the total project hours while ensuring that each scientist is assigned to at least one project and that no project exceeds its maximum allowed hours.  

The business configuration includes scalar parameters such as the hours required for a project, which directly influence the objective function. Additionally, a business logic formula calculates the average hours per scientist, providing a performance metric to evaluate the efficiency of the assignment process. The problem is designed to avoid nonlinear relationships, ensuring that all decisions and constraints are linear in nature.  

### Goals  
The optimization goal is to minimize the total project hours by optimally assigning scientists to projects. Success is measured by achieving the lowest possible total project hours while adhering to the constraints. The metric to optimize is the sum of the hours required for each project multiplied by the binary decision variable indicating whether a scientist is assigned to that project. This goal aligns with the operational parameters and ensures efficient resource allocation.  

## 2. Constraints  

The problem is subject to the following constraints:  
1. **Scientist Assignment Constraint**: Each scientist must be assigned to at least one project. This ensures that all scientists are actively contributing to the research efforts.  
2. **Project Hours Constraint**: The total hours assigned to a project must not exceed its maximum allowed hours. This ensures that projects are completed within their resource limits.  
3. **Project Assignment Constraint**: Each project must have at least one scientist assigned to it. This ensures that all projects are staffed and progress is made.  

These constraints are designed to align with linear mathematical forms, avoiding any nonlinear relationships such as variable products or divisions.  

## 3. Available Data  

### Database Schema  
```sql
-- Iteration 1 Database Schema
-- Objective: Schema changes include adding a table for maximum allowed project hours and refining the assignment table to fully map binary decision variables. Configuration logic updated to include scalar parameters for project hours and formulas for performance metrics.

CREATE TABLE Projects (
  Hours INTEGER
);

CREATE TABLE ProjectMaxHours (
  MaxHours INTEGER
);

CREATE TABLE AssignedTo (
  is_assigned BOOLEAN
);
```

### Data Dictionary  
- **Projects**:  
  - **Business Purpose**: Details of each project, including the hours required for completion.  
  - **Optimization Role**: Provides the coefficients for the objective function, which aims to minimize total project hours.  
  - **Columns**:  
    - **Hours**: Represents the hours required for the project. This value is used in the objective function to calculate total project hours.  

- **ProjectMaxHours**:  
  - **Business Purpose**: Specifies the maximum allowed hours for each project.  
  - **Optimization Role**: Provides the bounds for the constraint that ensures no project exceeds its maximum allowed hours.  
  - **Columns**:  
    - **MaxHours**: Represents the maximum allowed hours for the project. This value is used in the constraint to limit project hours.  

- **AssignedTo**:  
  - **Business Purpose**: Tracks the assignment of scientists to projects.  
  - **Optimization Role**: Represents the binary decision variables in the optimization model.  
  - **Columns**:  
    - **is_assigned**: Indicates whether a scientist is assigned to a project. This binary variable is used in the optimization model to determine assignments.  

### Current Stored Values  
```sql
-- Iteration 1 Realistic Data
-- Generated by triple expert (business + data + optimization)
-- Values were determined based on typical project hours and maximum allowed hours in research settings, ensuring a balance between project complexity and resource constraints.

-- Realistic data for Projects
INSERT INTO Projects (Hours) VALUES (120);
INSERT INTO Projects (Hours) VALUES (150);
INSERT INTO Projects (Hours) VALUES (100);

-- Realistic data for ProjectMaxHours
INSERT INTO ProjectMaxHours (MaxHours) VALUES (200);
INSERT INTO ProjectMaxHours (MaxHours) VALUES (250);
INSERT INTO ProjectMaxHours (MaxHours) VALUES (180);

-- Realistic data for AssignedTo
INSERT INTO AssignedTo (is_assigned) VALUES (True);
INSERT INTO AssignedTo (is_assigned) VALUES (False);
INSERT INTO AssignedTo (is_assigned) VALUES (True);
INSERT INTO AssignedTo (is_assigned) VALUES (True);
INSERT INTO AssignedTo (is_assigned) VALUES (False);
```