# Complete Optimization Problem and Solution: shop_membership

## 1. Problem Context and Goals

### Context  
A retail chain is focused on optimizing the allocation of membership benefits across its branches to maximize customer satisfaction. Customer satisfaction is measured by the total pounds spent by members at each branch. The business must make decisions on how to allocate resources to each branch to achieve this goal while adhering to two key operational limitations:  
1. **Total Membership Benefits Budget**: The retail chain has a fixed total budget allocated for membership benefits across all branches. This budget cannot be exceeded when distributing benefits.  
2. **Branch Capacity Limits**: Each branch has a maximum number of members it can handle, which is determined by its operational capacity. The total pounds spent by members at a branch must not exceed this capacity.  

The business configuration includes:  
- A total budget of 500,000 units allocated for membership benefits across all branches.  
- A formula to calculate the total capacity across all branches, which is the sum of the maximum number of members each branch can handle.  

The decision variables in this problem are the total pounds spent by members at each branch, which are continuous values. The goal is to maximize the sum of these values across all branches while respecting the budget and capacity constraints.  

### Goals  
The primary goal of this optimization problem is to maximize the total pounds spent by members across all branches. This metric directly reflects customer satisfaction and is aligned with the retail chain’s objective of enhancing member engagement. Success is measured by achieving the highest possible sum of total pounds spent while staying within the allocated budget and respecting each branch’s capacity limits.  

## 2. Constraints  

The optimization problem is subject to the following constraints:  
1. **Total Membership Benefits Budget**: The sum of the membership amounts allocated to all branches must not exceed the total budget of 500,000 units. This ensures that the retail chain operates within its financial limits.  
2. **Branch Capacity Limits**: The sum of the total pounds spent by members at all branches must not exceed the total capacity across all branches. This ensures that no branch is overloaded beyond its operational capabilities.  

These constraints are designed to ensure that the optimization problem remains linear, avoiding any scenarios that would require nonlinear relationships such as variable products or divisions.  

## 3. Available Data  

### Database Schema  
```sql
-- Iteration 1 Database Schema
-- Objective: Schema changes include creating a new table for branch capacity, modifying the purchase table to better map constraints, and adding configuration logic for budget and capacity limits.

CREATE TABLE purchase (
  Total_pounds FLOAT,
  branch_id INTEGER
);

CREATE TABLE branch (
  membership_amount FLOAT
);

CREATE TABLE branch_capacity (
  max_members INTEGER
);
```

### Data Dictionary  
- **purchase Table**:  
  - **Total_pounds**: Represents the total pounds spent by members at a specific branch. This is the key decision variable and objective coefficient in the optimization problem.  
  - **branch_id**: Identifies the branch where the purchase was made. This is used to map constraints to specific branches.  

- **branch Table**:  
  - **membership_amount**: Represents the maximum membership amount allocated to a branch. This is used as a constraint bound to ensure the total budget is not exceeded.  

- **branch_capacity Table**:  
  - **max_members**: Represents the maximum number of members a branch can handle. This is used as a constraint bound to ensure branch capacities are respected.  

### Current Stored Values  
```sql
-- Iteration 1 Realistic Data
-- Generated by triple expert (business + data + optimization)
-- Values were determined based on realistic retail chain operations, considering average customer spending, branch capacities, and budget allocations.

-- Realistic data for purchase
INSERT INTO purchase (Total_pounds, branch_id) VALUES (150.75, 1);
INSERT INTO purchase (Total_pounds, branch_id) VALUES (200.5, 2);
INSERT INTO purchase (Total_pounds, branch_id) VALUES (300.0, 3);

-- Realistic data for branch
INSERT INTO branch (membership_amount) VALUES (5000.0);
INSERT INTO branch (membership_amount) VALUES (7500.0);
INSERT INTO branch (membership_amount) VALUES (10000.0);

-- Realistic data for branch_capacity
INSERT INTO branch_capacity (max_members) VALUES (100);
INSERT INTO branch_capacity (max_members) VALUES (150);
INSERT INTO branch_capacity (max_members) VALUES (200);
```