# Complete Optimization Problem and Solution: student_1

## 1. Problem Context and Goals

### Context  
A school district is tasked with assigning students to classrooms in a way that balances the workload among teachers while ensuring that no classroom exceeds its capacity. The primary decision involves determining whether a student is assigned to a specific classroom, represented as a binary choice. The operational goal is to minimize the maximum number of students in any classroom, ensuring that the distribution of students is as even as possible across all classrooms.  

The business configuration includes a predefined maximum number of students allowed in any classroom, which is used to guide the optimization process. Additionally, a business logic formula calculates the maximum number of students in any classroom by summing the assignments for each classroom and identifying the highest value. This calculation directly supports the optimization objective of minimizing the maximum number of students in any classroom.  

The problem is designed to ensure that each student is assigned to exactly one classroom and that the total number of students in each classroom does not exceed its capacity. These requirements are expressed as linear relationships, avoiding any nonlinear scenarios such as variable products or divisions.  

### Goals  
The optimization goal is to minimize the maximum number of students in any classroom. Success is measured by achieving the smallest possible value for this maximum, ensuring that classroom assignments are balanced and within capacity limits. This goal aligns with the operational parameters and business configuration, which provide the necessary data and constraints to guide the optimization process.  

## 2. Constraints  

The problem is subject to the following constraints:  
1. **Student Assignment Constraint**: Each student must be assigned to exactly one classroom. This ensures that all students are placed and no student is left unassigned.  
2. **Classroom Capacity Constraint**: The total number of students assigned to each classroom must not exceed its predefined capacity. This ensures that classroom sizes remain within acceptable limits.  
3. **Maximum Students Constraint**: The total number of students assigned to any classroom must be less than or equal to the maximum number of students allowed in any classroom. This directly supports the optimization objective of minimizing the maximum number of students in any classroom.  

These constraints are expressed in linear terms, ensuring that the optimization problem remains straightforward and avoids any nonlinear complexities.  

## 3. Available Data  

### Database Schema  
```sql
-- Iteration 2 Database Schema
-- Objective: Added a new table for maximum students per classroom and updated business configuration logic to include a formula for calculating the maximum number of students in any classroom.

CREATE TABLE classroom_capacities (
  classroom_id INTEGER,
  capacity INTEGER
);

CREATE TABLE student_assignments (
  student_id INTEGER,
  classroom_id INTEGER,
  assignment BOOLEAN
);

CREATE TABLE max_students_per_classroom (
  classroom_id INTEGER,
  max_students INTEGER
);
```

### Data Dictionary  
- **classroom_capacities**:  
  - **Purpose**: Stores the maximum number of students allowed in each classroom.  
  - **Columns**:  
    - `classroom_id`: Unique identifier for each classroom.  
    - `capacity`: The maximum number of students allowed in the classroom.  

- **student_assignments**:  
  - **Purpose**: Tracks the assignment of students to classrooms.  
  - **Columns**:  
    - `student_id`: Unique identifier for each student.  
    - `classroom_id`: Unique identifier for each classroom.  
    - `assignment`: Indicates whether the student is assigned to the classroom (True or False).  

- **max_students_per_classroom**:  
  - **Purpose**: Represents the maximum number of students in any classroom.  
  - **Columns**:  
    - `classroom_id`: Unique identifier for each classroom.  
    - `max_students`: The maximum number of students in the classroom.  

### Current Stored Values  
```sql
-- Iteration 2 Realistic Data
-- Generated by triple expert (business + data + optimization)
-- Values were determined based on typical classroom sizes in a school district, ensuring that the number of students does not exceed classroom capacities and that the optimization problem remains meaningful.

-- Realistic data for classroom_capacities
INSERT INTO classroom_capacities (classroom_id, capacity) VALUES (1, 25);
INSERT INTO classroom_capacities (classroom_id, capacity) VALUES (2, 30);
INSERT INTO classroom_capacities (classroom_id, capacity) VALUES (3, 35);

-- Realistic data for student_assignments
INSERT INTO student_assignments (student_id, classroom_id, assignment) VALUES (101, 1, True);
INSERT INTO student_assignments (student_id, classroom_id, assignment) VALUES (102, 2, True);
INSERT INTO student_assignments (student_id, classroom_id, assignment) VALUES (103, 3, True);
INSERT INTO student_assignments (student_id, classroom_id, assignment) VALUES (104, 1, False);
INSERT INTO student_assignments (student_id, classroom_id, assignment) VALUES (105, 2, False);

-- Realistic data for max_students_per_classroom
INSERT INTO max_students_per_classroom (classroom_id, max_students) VALUES (1, 25);
INSERT INTO max_students_per_classroom (classroom_id, max_students) VALUES (2, 30);
INSERT INTO max_students_per_classroom (classroom_id, max_students) VALUES (3, 35);
```