# Complete Optimization Problem and Solution: twitter_1

## 1. Problem Context and Goals

### Context  
The business aims to maximize the reach of tweets by strategically selecting a subset of users to post tweets. The reach is determined by the total number of followers of the selected users. Each user has a specific follower count, and the decision to select a user for tweeting is binary—either they are selected or not. The selection process must adhere to two key operational constraints:  
1. **Total Tweet Limit**: The total number of tweets across all selected users cannot exceed a predefined maximum limit. This ensures that the system is not overwhelmed with tweets.  
2. **User Tweet Limit**: Each user has a maximum number of tweets they are allowed to post. This prevents any single user from being overburdened with tweeting responsibilities.  

The business configuration includes two critical scalar parameters:  
- **Maximum Total Tweets Allowed**: The system-wide limit on the total number of tweets that can be posted.  
- **Maximum Tweets Per User**: The individual limit on the number of tweets each user can post.  

These parameters are designed to balance user engagement with operational feasibility, ensuring a realistic and manageable tweet distribution strategy.

### Goals  
The primary goal of this optimization problem is to maximize the total reach of the tweets. This is achieved by selecting users whose combined follower count is as large as possible, while respecting the operational constraints. Success is measured by the total number of followers reached through the selected tweets. The optimization process ensures that the selection of users is both strategic and compliant with the predefined limits on tweet volume.

## 2. Constraints  

The optimization problem is subject to the following constraints:  
1. **Total Tweet Constraint**: The sum of tweets posted by all selected users must not exceed the maximum total number of tweets allowed. This ensures that the system operates within its capacity.  
2. **User Tweet Constraint**: Each selected user cannot post more tweets than their individual maximum limit. This prevents overloading any single user with tweeting responsibilities.  

These constraints are designed to maintain operational efficiency and user engagement, ensuring that the tweet distribution strategy is both effective and sustainable.

## 3. Available Data  

### Database Schema  
```sql
-- Iteration 1 Database Schema
-- Objective: Schema changes include creating new tables for decision variables and constraint bounds, and updating business configuration logic to include scalar parameters and formulas for optimization constraints.

CREATE TABLE user_profiles (
  user_id INTEGER,
  followers INTEGER,
  max_tweets_per_user INTEGER
);

CREATE TABLE tweet_selection (
  user_id INTEGER,
  is_selected BOOLEAN
);

CREATE TABLE user_tweet_limits (
  user_id INTEGER,
  max_tweets INTEGER
);
```

### Data Dictionary  
- **user_profiles**:  
  - **user_id**: Unique identifier for each user.  
  - **followers**: Number of followers of the user, used to determine the reach of their tweets.  
  - **max_tweets_per_user**: Maximum number of tweets allowed per user, used to constrain the number of tweets each user can post.  

- **tweet_selection**:  
  - **user_id**: Unique identifier for each user.  
  - **is_selected**: Binary indicator of whether the user is selected to tweet.  

- **user_tweet_limits**:  
  - **user_id**: Unique identifier for each user.  
  - **max_tweets**: Maximum number of tweets allowed per user, used to constrain the number of tweets each user can post.  

### Current Stored Values  
```sql
-- Iteration 1 Realistic Data
-- Generated by triple expert (business + data + optimization)
-- Values were determined based on realistic user profiles, follower counts, and tweet limits, ensuring a balance between user engagement and tweet frequency constraints.

-- Realistic data for user_profiles
INSERT INTO user_profiles (user_id, followers, max_tweets_per_user) VALUES (1, 1500, 3);
INSERT INTO user_profiles (user_id, followers, max_tweets_per_user) VALUES (2, 2500, 5);
INSERT INTO user_profiles (user_id, followers, max_tweets_per_user) VALUES (3, 1000, 2);

-- Realistic data for tweet_selection
INSERT INTO tweet_selection (user_id, is_selected) VALUES (1, False);
INSERT INTO tweet_selection (user_id, is_selected) VALUES (2, True);
INSERT INTO tweet_selection (user_id, is_selected) VALUES (3, False);

-- Realistic data for user_tweet_limits
INSERT INTO user_tweet_limits (user_id, max_tweets) VALUES (1, 3);
INSERT INTO user_tweet_limits (user_id, max_tweets) VALUES (2, 5);
INSERT INTO user_tweet_limits (user_id, max_tweets) VALUES (3, 2);
```