# Complete Optimization Problem and Solution: voter_1

## 1. Problem Context and Goals

### Context  
In this voting competition, contestants aim to maximize their votes across different states by strategically allocating a limited promotional budget. The decision-making process involves determining how much promotional budget to allocate to each contestant in each state, ensuring that the total spending does not exceed the available budget and that state-specific spending limits are respected. The promotional budget directly influences the number of votes received, with a fixed conversion rate that translates budget allocation into votes. The total available budget for promotional activities is set at 150,000 units, and the maximum promotional budget allowed per state is capped at 25,000 units. The conversion rate of promotional budget to votes is 0.6, meaning that every unit of promotional budget spent in a state generates 0.6 votes for the contestant. The goal is to allocate the budget in a way that maximizes the total votes received across all contestants and states, while adhering to these operational constraints.

### Goals  
The primary goal of this optimization problem is to maximize the total number of votes received by all contestants across all states. This is achieved by determining the optimal allocation of the promotional budget to each contestant in each state, ensuring that the total spending does not exceed the available budget and that state-specific spending limits are respected. Success is measured by the total votes received, which is directly influenced by the promotional budget allocation and the fixed conversion rate. The optimization process ensures that the budget is allocated efficiently and fairly, maximizing the overall impact of the promotional activities.

## 2. Constraints    

The optimization problem is subject to the following constraints:  
1. **Total Budget Constraint**: The sum of the promotional budgets allocated to all contestants across all states must not exceed the total available budget of 150,000 units. This ensures that the overall spending remains within the financial limits of the competition.  
2. **State-Level Budget Constraint**: The promotional budget allocated to any contestant in a single state must not exceed the maximum allowed budget per state, which is set at 25,000 units. This ensures that no single state receives an excessive share of the promotional resources, promoting fairness and balance in the competition.  

These constraints ensure that the promotional budget is allocated in a way that respects both the overall financial limits and the state-specific spending caps, leading to a fair and efficient distribution of resources.

## 3. Available Data  

### Database Schema  
```sql
-- Iteration 1 Database Schema
-- Objective: Schema changes include creating new tables for decision variables and constraints, moving scalar parameters to business_configuration_logic.json, and updating the data dictionary to reflect optimization mappings.

CREATE TABLE PROMOTIONAL_BUDGET (
  contestant_number INTEGER,
  state STRING,
  budget FLOAT
);

CREATE TABLE VOTES_RECEIVED (
  contestant_number INTEGER,
  state STRING,
  votes INTEGER
);


```

### Data Dictionary  
- **PROMOTIONAL_BUDGET**: This table contains the promotional budget allocated to each contestant in each state.  
  - **contestant_number**: A unique identifier for each contestant.  
  - **state**: The state where the promotional budget is allocated.  
  - **budget**: The amount of promotional budget allocated to the contestant in the specified state.  

- **VOTES_RECEIVED**: This table contains the number of votes received by each contestant in each state.  
  - **contestant_number**: A unique identifier for each contestant.  
  - **state**: The state where the votes were received.  
  - **votes**: The number of votes received by the contestant in the specified state.  

### Current Stored Values  
```sql
-- Iteration 1 Realistic Data
-- Generated by triple expert (business + data + optimization)
-- Values were determined based on realistic promotional budgets, conversion rates, and state-specific constraints, ensuring the optimization problem is meaningful and solvable.

-- Realistic data for PROMOTIONAL_BUDGET
INSERT INTO PROMOTIONAL_BUDGET (contestant_number, state, budget) VALUES (1, 'CA', 15000.0);
INSERT INTO PROMOTIONAL_BUDGET (contestant_number, state, budget) VALUES (1, 'TX', 10000.0);
INSERT INTO PROMOTIONAL_BUDGET (contestant_number, state, budget) VALUES (1, 'NY', 20000.0);
INSERT INTO PROMOTIONAL_BUDGET (contestant_number, state, budget) VALUES (2, 'CA', 12000.0);
INSERT INTO PROMOTIONAL_BUDGET (contestant_number, state, budget) VALUES (2, 'TX', 15000.0);
INSERT INTO PROMOTIONAL_BUDGET (contestant_number, state, budget) VALUES (2, 'NY', 18000.0);
INSERT INTO PROMOTIONAL_BUDGET (contestant_number, state, budget) VALUES (3, 'CA', 20000.0);
INSERT INTO PROMOTIONAL_BUDGET (contestant_number, state, budget) VALUES (3, 'TX', 8000.0);
INSERT INTO PROMOTIONAL_BUDGET (contestant_number, state, budget) VALUES (3, 'NY', 12000.0);

-- Realistic data for VOTES_RECEIVED
INSERT INTO VOTES_RECEIVED (contestant_number, state, votes) VALUES (1, 'CA', 7500);
INSERT INTO VOTES_RECEIVED (contestant_number, state, votes) VALUES (1, 'TX', 5000);
INSERT INTO VOTES_RECEIVED (contestant_number, state, votes) VALUES (1, 'NY', 10000);
INSERT INTO VOTES_RECEIVED (contestant_number, state, votes) VALUES (2, 'CA', 6000);
INSERT INTO VOTES_RECEIVED (contestant_number, state, votes) VALUES (2, 'TX', 7500);
INSERT INTO VOTES_RECEIVED (contestant_number, state, votes) VALUES (2, 'NY', 9000);
INSERT INTO VOTES_RECEIVED (contestant_number, state, votes) VALUES (3, 'CA', 10000);
INSERT INTO VOTES_RECEIVED (contestant_number, state, votes) VALUES (3, 'TX', 4000);
INSERT INTO VOTES_RECEIVED (contestant_number, state, votes) VALUES (3, 'NY', 6000);


```