# Complete Optimization Problem and Solution: voter_2

## 1. Problem Context and Goals

### Context  
A university is focused on maximizing student participation in elections by strategically allocating resources such as campaign materials and reminders to different majors. The allocation is based on historical voting patterns and student demographics. The university aims to ensure that resource distribution respects the total budget, provides a minimum level of support to each major, avoids excessive allocation to any single major, and is proportional to the number of students in each major.  

The decision variables represent the amount of resources allocated to each major, which must be integer values. The objective is to maximize the total expected votes across all election positions by leveraging the relationship between resource allocation and expected votes.  

The business configuration includes:  
- A total budget of 50,000 units available for resource allocation, which serves as the upper limit for the sum of all resource allocations.  
- A minimum resource allocation of 500 units per major, ensuring each major receives a baseline level of support.  
- A maximum resource allocation of 5,000 units per major, preventing any single major from consuming an excessive share of the budget.  
- A resource allocation of 10 units per student, ensuring proportional distribution based on the number of students in each major.  

The expected votes per major are calculated using a formula that incorporates historical voting data and a student engagement factor. This calculation provides the coefficients used in the objective function to measure the impact of resource allocation on expected votes.  

### Goals  
The primary goal of this optimization problem is to maximize the total expected votes across all majors by allocating resources effectively. Success is measured by the sum of the expected votes per major multiplied by the corresponding resource allocation. This linear relationship ensures that the optimization goal is directly tied to the operational decision of resource distribution.  

## 2. Constraints  

The resource allocation must adhere to the following constraints:  
1. The total amount of resources allocated across all majors must not exceed the total budget of 50,000 units.  
2. Each major must receive at least 500 units of resources to ensure a minimum level of support.  
3. No major can receive more than 5,000 units of resources to prevent excessive allocation to any single major.  
4. The resource allocation for each major must be proportional to the number of students in that major, with a maximum of 10 units allocated per student.  

These constraints ensure that the resource allocation is both fair and feasible, aligning with the university’s operational and budgetary requirements.  

## 3. Available Data  

### Database Schema  
```sql
-- Iteration 1 Database Schema
-- Objective: Schema changes include creating tables for expected votes, resource allocations, and budget constraints. Configuration logic updates include scalar parameters for budget and resource limits, and formulas for expected votes calculation.

CREATE TABLE ExpectedVotesPerMajor (
  major STRING,
  expected_votes INTEGER
);

CREATE TABLE ResourceAllocationPerMajor (
  major STRING,
  resource_allocation INTEGER
);

CREATE TABLE Student (
  major STRING,
  number_of_students_in_major INTEGER
);
```

### Data Dictionary  
- **ExpectedVotesPerMajor**:  
  - **Business Purpose**: Stores the expected number of votes per major based on historical voting data.  
  - **Optimization Role**: Provides the coefficients used in the objective function to measure the impact of resource allocation on expected votes.  
  - **Columns**:  
    - `major`: The name of the major (e.g., Computer Science, Biology).  
    - `expected_votes`: The expected number of votes for the major, derived from historical data and engagement factors.  

- **ResourceAllocationPerMajor**:  
  - **Business Purpose**: Tracks the amount of resources allocated to each major.  
  - **Optimization Role**: Represents the decision variables in the optimization model.  
  - **Columns**:  
    - `major`: The name of the major (e.g., Computer Science, Biology).  
    - `resource_allocation`: The amount of resources allocated to the major, which must be an integer value.  

- **Student**:  
  - **Business Purpose**: Contains demographic information about students, including the number of students in each major.  
  - **Optimization Role**: Provides data used to calculate proportional resource allocation based on student numbers.  
  - **Columns**:  
    - `major`: The name of the major (e.g., Computer Science, Biology).  
    - `number_of_students_in_major`: The number of students enrolled in the major, used to determine proportional resource allocation.  

### Current Stored Values  
```sql
-- Iteration 1 Realistic Data
-- Generated by triple expert (business + data + optimization)
-- Values were determined based on realistic university demographics, historical voting patterns, and resource allocation practices. The goal was to ensure that the optimization problem is meaningful and solvable while respecting business configuration logic.

-- Realistic data for ExpectedVotesPerMajor
INSERT INTO ExpectedVotesPerMajor (major, expected_votes) VALUES ('Computer Science', 150);
INSERT INTO ExpectedVotesPerMajor (major, expected_votes) VALUES ('Biology', 100);
INSERT INTO ExpectedVotesPerMajor (major, expected_votes) VALUES ('History', 80);

-- Realistic data for ResourceAllocationPerMajor
INSERT INTO ResourceAllocationPerMajor (major, resource_allocation) VALUES ('Computer Science', 2000);
INSERT INTO ResourceAllocationPerMajor (major, resource_allocation) VALUES ('Biology', 1500);
INSERT INTO ResourceAllocationPerMajor (major, resource_allocation) VALUES ('History', 1000);

-- Realistic data for Student
INSERT INTO Student (major, number_of_students_in_major) VALUES ('Computer Science', 200);
INSERT INTO Student (major, number_of_students_in_major) VALUES ('Biology', 150);
INSERT INTO Student (major, number_of_students_in_major) VALUES ('History', 100);
```