# Complete Optimization Problem and Solution: world_1

## 1. Problem Context and Goals

### Context  
A government agency is tasked with allocating a fixed budget across multiple cities to maximize the total population served. The allocation must ensure equitable distribution across districts while adhering to budget constraints. Each city has a specific population size, and the budget allocated to a city directly impacts the number of people served. The agency has established operational parameters to guide the allocation process:  
- **Total Budget Available for Allocation**: The agency has a fixed total budget of 1,000,000 units, which cannot be exceeded.  
- **Minimum Budget Allocation per City**: Each city must receive at least 50,000 units to ensure even smaller cities receive a fair share.  
- **Minimum Budget Allocation per District**: Each district must receive a minimum of 200,000 units to ensure equitable distribution across regions.  

The decision variables in this problem are the budget allocations to each city, represented as continuous values. The objective is to maximize the total population served by allocating the budget in a way that respects these constraints.  

### Goals  
The primary goal of this optimization problem is to maximize the total population served by the budget allocation. This is achieved by prioritizing cities with larger populations while ensuring that all cities and districts receive their minimum required allocations. Success is measured by the total population served, which is directly proportional to the budget allocated to each city. The optimization process ensures that the allocation is both efficient and equitable, aligning with the agency’s operational and policy objectives.  

## 2. Constraints  

The budget allocation process is subject to the following constraints:  
1. **Total Budget Limit**: The sum of all budget allocations across cities must not exceed the total available budget of 1,000,000 units.  
2. **Minimum Allocation per City**: Each city must receive at least 50,000 units of the budget to ensure a fair distribution.  
3. **Minimum Allocation per District**: The total budget allocated to all cities within a district must be at least 200,000 units to maintain equity across regions.  

These constraints ensure that the budget allocation is both feasible and aligned with the agency’s operational requirements.  

## 3. Available Data  

### Database Schema  
```sql
-- Iteration 1 Database Schema
-- Objective: Schema changes include creating tables for budget allocation, districts, and cities. Configuration logic updates include adding scalar parameters for total budget, minimum allocation per city, and minimum allocation per district.

CREATE TABLE city (
  CityID INTEGER,
  Population INTEGER,
  DistrictID INTEGER
);

CREATE TABLE district (
  DistrictID INTEGER,
  DistrictName STRING
);

CREATE TABLE budget_allocation (
  CityID INTEGER,
  Allocation FLOAT
);
```

### Data Dictionary  
- **city**: Stores city-specific data, including population and district affiliation.  
  - **CityID**: Unique identifier for each city.  
  - **Population**: Population of the city, used as the coefficient in the objective function.  
  - **DistrictID**: District to which the city belongs, used for grouping in district-level constraints.  
- **district**: Stores district-specific data, including district names.  
  - **DistrictID**: Unique identifier for each district.  
  - **DistrictName**: Name of the district, used for business context.  
- **budget_allocation**: Stores the budget allocated to each city.  
  - **CityID**: City to which the budget is allocated.  
  - **Allocation**: Budget allocated to the city, representing the decision variable in the optimization problem.  

### Current Stored Values  
```sql
-- Iteration 1 Realistic Data
-- Generated by triple expert (business + data + optimization)
-- Values were determined based on realistic population sizes, budget allocations, and district requirements, ensuring the optimization problem is meaningful and solvable.

-- Realistic data for city
INSERT INTO city (CityID, Population, DistrictID) VALUES (1, 150000, 1);
INSERT INTO city (CityID, Population, DistrictID) VALUES (2, 250000, 2);
INSERT INTO city (CityID, Population, DistrictID) VALUES (3, 100000, 3);

-- Realistic data for district
INSERT INTO district (DistrictID, DistrictName) VALUES (1, 'North');
INSERT INTO district (DistrictID, DistrictName) VALUES (2, 'South');
INSERT INTO district (DistrictID, DistrictName) VALUES (3, 'East');

-- Realistic data for budget_allocation
INSERT INTO budget_allocation (CityID, Allocation) VALUES (1, 60000.0);
INSERT INTO budget_allocation (CityID, Allocation) VALUES (2, 80000.0);
INSERT INTO budget_allocation (CityID, Allocation) VALUES (3, 50000.0);
```