# Complete Optimization Problem and Solution: wrestler

## 1. Problem Context and Goals

### Context  
In the context of organizing a wrestling event, the goal is to select a team of wrestlers that maximizes the total number of days their reigns have been held, while ensuring a balanced and competitive match. The selection process involves making binary decisions for each wrestler—whether to include them in the event or not. The operational parameters guiding this decision include the number of days each wrestler has held their reign, the maximum number of wrestlers that can be selected, and the maximum number of eliminations allowed across all selected wrestlers.  

The business configuration sets a limit of six wrestlers that can be selected for the event, ensuring the match remains manageable and competitive. Additionally, the total number of eliminations by the selected wrestlers must not exceed thirty, maintaining a feasible upper limit for competitive dynamics. The selection must also ensure an equal number of wrestlers from Team A and Team B, promoting a balanced team composition.  

### Goals  
The primary optimization goal is to maximize the total number of days the selected wrestlers have held their reigns. This is achieved by selecting wrestlers whose combined days held contribute the most to the overall total, while adhering to the constraints on the number of wrestlers, eliminations, and team balance. Success is measured by the total days held by the selected wrestlers, ensuring the event features wrestlers with the most significant and impactful reigns.  

## 2. Constraints  

The selection process is subject to the following constraints:  
1. **Total Wrestlers Constraint**: The total number of wrestlers selected for the event must not exceed the maximum allowed limit of six. This ensures the event remains manageable and competitive.  
2. **Total Eliminations Constraint**: The total number of eliminations by the selected wrestlers must not exceed the maximum allowed limit of thirty. This maintains a feasible upper limit for competitive dynamics.  
3. **Team Balance Constraint**: The number of wrestlers selected from Team A must equal the number of wrestlers selected from Team B. This ensures a balanced and fair team composition for the event.  

## 3. Available Data  

### Database Schema  
```sql
-- Iteration 1 Database Schema
-- Objective: Schema changes include creating new tables for team assignments and eliminations, modifying the wrestler table to include optimization-relevant data, and adding business configuration logic for scalar parameters and formulas.

CREATE TABLE wrestler (
  Days_held INTEGER,
  selection_status BOOLEAN
);

CREATE TABLE wrestler_team (
  wrestler_id INTEGER,
  team STRING
);

CREATE TABLE wrestler_eliminations (
  wrestler_id INTEGER,
  eliminations INTEGER
);
```

### Data Dictionary  
- **wrestler**: Stores wrestler information relevant to optimization.  
  - **Days_held**: The number of days the wrestler's reign has been held. This is used as the coefficient for maximizing the total days held.  
  - **selection_status**: Indicates whether the wrestler is selected for the event. This is the binary decision variable in the optimization process.  
- **wrestler_team**: Contains team assignments for each wrestler.  
  - **wrestler_id**: Unique identifier for the wrestler, linking them to their team.  
  - **team**: The team assignment (Team A or Team B), used to enforce team balance constraints.  
- **wrestler_eliminations**: Tracks the number of eliminations per wrestler.  
  - **wrestler_id**: Unique identifier for the wrestler, linking them to their elimination count.  
  - **eliminations**: The number of eliminations by the wrestler, used to enforce the total eliminations constraint.  

### Current Stored Values  
```sql
-- Iteration 1 Realistic Data
-- Generated by triple expert (business + data + optimization)
-- Values were determined based on realistic wrestling event scenarios, ensuring a balanced team composition and feasible elimination limits. The number of wrestlers and eliminations were chosen to align with typical event sizes and competitive dynamics.

-- Realistic data for wrestler
INSERT INTO wrestler (Days_held, selection_status) VALUES (150, False);
INSERT INTO wrestler (Days_held, selection_status) VALUES (250, True);
INSERT INTO wrestler (Days_held, selection_status) VALUES (100, False);

-- Realistic data for wrestler_team
INSERT INTO wrestler_team (wrestler_id, team) VALUES (1, 'Team A');
INSERT INTO wrestler_team (wrestler_id, team) VALUES (2, 'Team B');
INSERT INTO wrestler_team (wrestler_id, team) VALUES (3, 'Team A');

-- Realistic data for wrestler_eliminations
INSERT INTO wrestler_eliminations (wrestler_id, eliminations) VALUES (1, 8);
INSERT INTO wrestler_eliminations (wrestler_id, eliminations) VALUES (2, 12);
INSERT INTO wrestler_eliminations (wrestler_id, eliminations) VALUES (3, 5);
```