#!/usr/bin/env python3

import os
from dotenv import load_dotenv

load_dotenv()

# API Configuration - Changed from RITS to OpenAI
OPENAI_API_KEY = "YOUR_OPENAI_API_KEY_HERE"'OPENAI_API_KEY_PLACEHOLDER')
BASE_URL = "https://api.openai.com/v1"
MODEL_NAME = "gpt-4o"  # Changed to GPT-4o for better performance

# API Parameters
MAX_TOKENS = 16384  # Much more aggressive for complex outputs
TEMPERATURE = 0.05
TOP_P = 0.9
TIMEOUT = 600  # Increased timeout for larger responses

# Original RITS configuration (commented out)
# RITS_API_KEY = 'RITS_API_PLACEHOLDER'
# MODEL_INFERENCE_ENDPOINT = "API_ENDPOINT_PLACEHOLDER/deepseek-v3-h200"
# BASE_URL = "API_ENDPOINT_PLACEHOLDER/deepseek-v3-h200/v1"
# MODEL_NAME = "deepseek-ai/DeepSeek-V3"

# Alternating Optimization Algorithm parameters
MAX_ALTERNATING_ITERATIONS = 5
MAX_TABLES = 5
MIN_CONSTRAINTS = 2
MAX_CONSTRAINTS = 20
MAX_PARAMETERS = 20
MIN_SAMPLE_ROWS = 3
MAX_SAMPLE_ROWS = 20

# Mathematical verification parameters
MAX_VERIFICATION_ATTEMPTS = 5
VERIFICATION_THRESHOLD = 0.99

# Solver parameters
SOLVER_TIMEOUT = 500
OPTIM_VENV_PATH = os.getenv("OPTIM_VENV_PATH", "/dccstor/nl2opt/miniforge3/envs/nl2opt_optim")

# Max reprompt parameters
MAX_JSON_REPROMPT_ATTEMPTS = 10

# Solver retry parameters
MAX_SOLVER_RETRY_ATTEMPTS = 5
SOLVER_CONSISTENCY_TOLERANCE = 1e-6

# Paths
SPIDER_DIR = "../spider"
OUTPUT_BASE_DIR = "./text2opt_dataset_alternating_optimization"
TEMPLATES_DIR = "./templates"